/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.features.papi;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.economy.manager.EconomyManager;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.annotations.InjectPlugin;
import com.zetaplugins.zetacore.annotations.Manager;
import com.zetaplugins.zetacore.annotations.Papi;
import com.zetaplugins.zetacore.annotations.PapiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.OfflinePlayer;

@Manager
public class EconomyPlaceholders {
    private List<Map.Entry<UUID, Double>> cachedTopBalances = new ArrayList<Map.Entry<UUID, Double>>();
    private long lastCacheTime = 0L;
    private final long cacheDurationMillis = 30000L;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    @InjectPlugin
    private EssentialZ plugin;
    @InjectManager
    private EconomyManager economyManager;

    @Papi(identifier="balance")
    public String balancePlaceholder(OfflinePlayer player) {
        double balance = this.economyManager.getBalance(player);
        return this.economyManager.format(balance);
    }

    @Papi(identifier="balance_raw")
    public String balanceRawPlaceholder(OfflinePlayer player) {
        double balance = this.economyManager.getBalance(player);
        return String.valueOf(balance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Papi(identifier="baltop_{rank}_balance")
    public String baltopBalancePlaceholder(OfflinePlayer player, @PapiParam(value="rank") int rank) {
        if (rank < 1) {
            return "Invalid rank";
        }
        this.updateCacheIfNeeded();
        this.lock.readLock().lock();
        try {
            if (rank > this.cachedTopBalances.size()) {
                String string = "N/A";
                return string;
            }
            Double balance = this.cachedTopBalances.get(rank - 1).getValue();
            String string = this.economyManager.format(balance);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Papi(identifier="baltop_{rank}_balance_raw")
    public String baltopBalanceRawPlaceholder(OfflinePlayer player, @PapiParam(value="rank") int rank) {
        if (rank < 1) {
            return "Invalid rank";
        }
        this.updateCacheIfNeeded();
        this.lock.readLock().lock();
        try {
            if (rank > this.cachedTopBalances.size()) {
                String string = "N/A";
                return string;
            }
            Double balance = this.cachedTopBalances.get(rank - 1).getValue();
            String string = String.valueOf(balance);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Papi(identifier="baltop_{rank}_player")
    public String baltopPlayerPlaceholder(OfflinePlayer player, @PapiParam(value="rank") int rank) {
        if (rank < 1) {
            return "Invalid rank";
        }
        this.updateCacheIfNeeded();
        this.lock.readLock().lock();
        try {
            if (rank > this.cachedTopBalances.size()) {
                String string = "N/A";
                return string;
            }
            UUID playerUUID = this.cachedTopBalances.get(rank - 1).getKey();
            OfflinePlayer topPlayer = this.plugin.getServer().getOfflinePlayer(playerUUID);
            String string = topPlayer.getName() != null ? topPlayer.getName() : "Unknown";
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheIfNeeded() {
        long now = System.currentTimeMillis();
        if (now - this.lastCacheTime < 30000L) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            Map<UUID, Double> topBalances = this.economyManager.getTopBalances(10);
            this.cachedTopBalances = topBalances.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).toList();
            this.lastCacheTime = now;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

