/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.features.economy.manager;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.economy.manager.EconomyManager;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.annotations.InjectPlugin;
import com.zetaplugins.zetacore.annotations.PostManagerConstruct;
import java.util.Map;
import java.util.UUID;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultEconomyManager
implements EconomyManager {
    private Economy economy;
    @InjectPlugin
    private EssentialZ plugin;
    @InjectManager
    private Storage storage;

    @PostManagerConstruct
    public void init() {
        RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp != null) {
            this.economy = (Economy)rsp.getProvider();
        }
    }

    @Override
    public double getBalance(OfflinePlayer player) {
        if (this.economy == null) {
            return 0.0;
        }
        return this.economy.getBalance(player);
    }

    @Override
    public void deposit(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            amount = 0.0;
        }
        if (this.economy != null) {
            this.economy.depositPlayer(player, amount);
        }
    }

    @Override
    public boolean withdraw(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            amount = 0.0;
        }
        if (this.economy != null) {
            return this.economy.withdrawPlayer(player, amount).transactionSuccess();
        }
        return false;
    }

    @Override
    public void setBalance(OfflinePlayer player, double amount) {
        if (this.economy == null) {
            return;
        }
        double currentBalance = this.economy.getBalance(player);
        double difference = amount - currentBalance;
        if (difference > 0.0) {
            this.economy.depositPlayer(player, difference);
        } else if (difference < 0.0) {
            this.economy.withdrawPlayer(player, -difference);
        }
    }

    @Override
    public String format(double amount) {
        return this.economy.format(amount);
    }

    public Economy getEconomy() {
        return this.economy;
    }

    @Override
    public Map<UUID, Double> getTopBalances(int topN) {
        return this.storage.getPlayerRepository().getTopBalances(topN);
    }
}

