/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.features;

import com.zetaplugins.zetacore.annotations.Manager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@Manager
public class SocialSpyManager {
    private final Map<UUID, Set<UUID>> socialSpyMap = new HashMap<UUID, Set<UUID>>();

    public List<UUID> getAllSpyingViewers(UUID ... targetUUIDs) {
        HashSet<UUID> targetSet = new HashSet<UUID>(Arrays.asList(targetUUIDs));
        ArrayList<UUID> viewers = new ArrayList<UUID>();
        block0: for (Map.Entry<UUID, Set<UUID>> entry : this.socialSpyMap.entrySet()) {
            for (UUID targetUUID : targetSet) {
                if (!entry.getValue().contains(targetUUID)) continue;
                viewers.add(entry.getKey());
                continue block0;
            }
        }
        return viewers;
    }

    public boolean toggleSpyOn(UUID viewerUUID, UUID targetUUID) {
        Set targets = this.socialSpyMap.computeIfAbsent(viewerUUID, k -> new HashSet());
        if (targets.contains(targetUUID)) {
            targets.remove(targetUUID);
            if (targets.isEmpty()) {
                this.socialSpyMap.remove(viewerUUID);
            }
            return false;
        }
        targets.add(targetUUID);
        return true;
    }

    public void turnOffAllSpying(UUID viewerUUID) {
        this.socialSpyMap.remove(viewerUUID);
    }
}

