/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.worldcontrol.time;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.TimeConverter;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@AutoRegisterCommand(commands={"time"}, permission="essentialz.time", description="Manage the time in your world.", usage="/time [day|night|dawn|dusk|noon|midnight|18:20|10pm|3000ticks]")
public class TimeCommand
extends EszCommand {
    public TimeCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender commandSender, Command command, String s, ArgumentList args) throws CommandException {
        int ticks;
        if (!(commandSender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)commandSender;
        String timeToSet = args.getString(0, null);
        if (timeToSet == null) {
            long currentTime = player.getWorld().getTime();
            player.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.CURRENT_TIME, new MessageManager.Replaceable<String>("{time}", TimeConverter.ticksToTimeString(currentTime)), new MessageManager.Replaceable<String>("{ticks}", String.valueOf(currentTime))));
            return true;
        }
        switch (timeToSet.toLowerCase()) {
            case "day": {
                ticks = 1000;
                break;
            }
            case "night": {
                ticks = 13000;
                break;
            }
            case "dawn": {
                ticks = 0;
                break;
            }
            case "dusk": {
                ticks = 12000;
                break;
            }
            case "noon": 
            case "12:00": {
                ticks = 6000;
                break;
            }
            case "midnight": 
            case "00:00": 
            case "24:00": {
                ticks = 18000;
                break;
            }
            default: {
                try {
                    if (timeToSet.endsWith("ticks")) {
                        ticks = Integer.parseInt(timeToSet.replace("ticks", "").trim());
                        break;
                    }
                    ticks = TimeConverter.timeStringToTicks(timeToSet);
                    break;
                }
                catch (NumberFormatException e) {
                    commandSender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.INVALID_TIME_FORMAT, new MessageManager.Replaceable[0]));
                    return true;
                }
            }
        }
        player.getWorld().setTime((long)ticks);
        player.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.TIME_SET, new MessageManager.Replaceable<String>("{time}", TimeConverter.ticksToTimeString(ticks)), new MessageManager.Replaceable<String>("{ticks}", String.valueOf(ticks))));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return List.of("day", "night", "dawn", "dusk", "noon", "midnight", "06:00", "12:00", "18:00", "00:00", "1000ticks", "13000ticks");
        }
        return List.of();
    }
}

