/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.moderation;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.SocialSpyManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.List;
import java.util.UUID;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"socialspy"}, permission="essentialz.socialspy", description="Toggle socialspy for a player.", usage="/socialspy <player>")
public class SocialspyCommand
extends EszCommand {
    @InjectManager
    private SocialSpyManager socialSpyManager;

    public SocialspyCommand(EssentialZ plugin) {
        super(plugin);
    }

    private UUID getViewerUUID(CommandSender sender) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return player.getUniqueId();
        }
        return EssentialZ.CONSOLE_UUID;
    }

    @Override
    public boolean execute(CommandSender commandSender, Command command, String s, ArgumentList args) throws CommandException {
        Player targetPlayer;
        if (args.size() > 1) {
            throw new CommandUsageException("Usage: /socialspy <player>");
        }
        if (args.size() == 0) {
            UUID viewerUuid = this.getViewerUUID(commandSender);
            this.socialSpyManager.turnOffAllSpying(viewerUuid);
            commandSender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.SOCIALSPY_DISABLED_ALL, new MessageManager.Replaceable[0]));
            return true;
        }
        UUID viewerUuid = this.getViewerUUID(commandSender);
        boolean nowSpying = this.socialSpyManager.toggleSpyOn(viewerUuid, (targetPlayer = args.getPlayer(0, (JavaPlugin)this.getPlugin())).getUniqueId());
        if (nowSpying) {
            commandSender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.SOCIALSPY_ENABLED, new MessageManager.Replaceable<String>("{player}", targetPlayer.getName())));
        } else {
            commandSender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.SOCIALSPY_DISABLED, new MessageManager.Replaceable<String>("{player}", targetPlayer.getName())));
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0 && Permission.SOCIALSPY.has((Permissible)commandSender)) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

