/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.items;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"skull"}, description="Gives a player head of the specified player.", usage="/skull <player> [player]", permission="essentialz.skull")
public class SkullCommand
extends EszCommand {
    public SkullCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandUsageException {
        if (args.size() < 1) {
            throw new CommandUsageException("/skull <player> [player]");
        }
        OfflinePlayer skullPlayer = ((EssentialZ)((Object)this.getPlugin())).getServer().getOfflinePlayer(args.getArg(0));
        if (args.hasArg(1)) {
            Player targetPlayer = args.getPlayer(1, (JavaPlugin)this.getPlugin());
            if (targetPlayer == null) {
                sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.PLAYER_NOT_FOUND, new MessageManager.Replaceable[0]));
                return false;
            }
            targetPlayer.getInventory().addItem(new ItemStack[]{this.getSkull(skullPlayer)});
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.SKULL_GIVEN, new MessageManager.Replaceable<String>("{receiver}", targetPlayer.getName()), new MessageManager.Replaceable<String>("{player}", skullPlayer.getName())));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.SPECIFY_PLAYER_OR_BE_PLAYER, new MessageManager.Replaceable[0]));
            return false;
        }
        Player targetPlayer = (Player)sender;
        targetPlayer.getInventory().addItem(new ItemStack[]{this.getSkull(skullPlayer)});
        sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.SKULL_RECEIVED, new MessageManager.Replaceable<String>("{player}", skullPlayer.getName())));
        return false;
    }

    private ItemStack getSkull(OfflinePlayer player) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwningPlayer(player);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0 || args.getCurrentArgIndex() == 1) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

