/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.items;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

@AutoRegisterCommand(commands={"repair"}, description="Repair your held item", usage="/repair [hand|all]", permission="essentialz.repair")
public class RepairCommand
extends EszCommand {
    public RepairCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandSenderMustBePlayerException {
        String operation = args.getString(0, "hand").toLowerCase();
        if (!(sender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)sender;
        if (operation.equals("all")) {
            int repairedCount = this.repairAllItems(player);
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.ITEMS_REPAIRED_ALL, new MessageManager.Replaceable<String>("{count}", String.valueOf(repairedCount))));
            return true;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType().isAir()) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.REPAIR_MUST_HOLD_ITEM, new MessageManager.Replaceable[0]));
            return false;
        }
        boolean success = this.repair(item);
        if (!success) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.ITEM_NOT_REPAIRABLE, new MessageManager.Replaceable[0]));
            return false;
        }
        sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.ITEM_REPAIRED, new MessageManager.Replaceable[0]));
        return true;
    }

    private int repairAllItems(Player player) {
        int repairedCount = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (!this.repair(item)) continue;
            ++repairedCount;
        }
        return repairedCount;
    }

    private boolean repair(ItemStack item) {
        if (item == null) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof Damageable) {
            Damageable damageable = (Damageable)meta;
            if (damageable.getDamage() == 0) {
                return false;
            }
            damageable.setDamage(0);
            item.setItemMeta(meta);
            return true;
        }
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return List.of("hand", "all");
        }
        return List.of();
    }
}

