/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.listeners;

import com.zetaplugins.essentialz.config.economy.CommandFeesConfigSection;
import com.zetaplugins.essentialz.config.economy.EconomyConfig;
import com.zetaplugins.essentialz.features.economy.manager.EconomyManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.MessageStyle;
import com.zetaplugins.zetacore.annotations.AutoRegisterListener;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.services.config.ConfigService;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

@AutoRegisterListener
public class PlayerCommandPreprocessListener
implements Listener {
    @InjectManager
    private MessageManager messageManager;
    @InjectManager
    private ConfigService configService;
    @InjectManager
    private EconomyManager economyManager;

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String message = event.getMessage().toLowerCase();
        Player sender = event.getPlayer();
        CommandFeesConfigSection commandFeesConfig = this.configService.getConfig(EconomyConfig.class).getCommandFees();
        if (!commandFeesConfig.isEnabled()) {
            return;
        }
        String commandName = message.contains("/") ? message.split(" ")[0].substring(1) : message;
        double cmdFee = commandFeesConfig.getFees().getOrDefault(commandName, 0.0);
        if (cmdFee <= 0.0) {
            return;
        }
        double senderBalance = this.economyManager.getBalance((OfflinePlayer)sender);
        if (senderBalance < cmdFee) {
            sender.sendMessage(this.messageManager.getAndFormatMsg(MessageStyle.ERROR, "insufficientFundsCommandFee", "{ac}You do not have enough funds to pay the command fee of {fee}!", new MessageManager.Replaceable<String>("{fee}", this.economyManager.format(cmdFee))));
            event.setCancelled(true);
        } else {
            this.economyManager.withdraw((OfflinePlayer)sender, cmdFee);
        }
    }
}

