/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.worldcontrol.time;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.TimeConverter;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@AutoRegisterCommand(commands={"day", "night", "noon", "midnight", "dawn", "dusk"}, description="Shortcut commands to set the time.", usage="/<command>", permission="essentialz.time")
public class TimeShortcutCommand
extends EszCommand {
    public TimeShortcutCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender commandSender, Command command, String s, ArgumentList argumentList) throws CommandException {
        int ticks;
        if (!(commandSender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)commandSender;
        switch (command.getName().toLowerCase()) {
            case "day": {
                ticks = 1000;
                break;
            }
            case "night": {
                ticks = 13000;
                break;
            }
            case "dawn": {
                ticks = 0;
                break;
            }
            case "dusk": {
                ticks = 12000;
                break;
            }
            case "noon": {
                ticks = 6000;
                break;
            }
            case "midnight": {
                ticks = 18000;
                break;
            }
            default: {
                commandSender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.INVALID_TIME_FORMAT, new MessageManager.Replaceable[0]));
                return true;
            }
        }
        player.getWorld().setTime((long)ticks);
        player.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.TIME_SET, new MessageManager.Replaceable<String>("{time}", TimeConverter.ticksToTimeString(ticks)), new MessageManager.Replaceable<String>("{ticks}", String.valueOf(ticks))));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, Command command, ArgumentList argumentList) {
        return List.of();
    }
}

