/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.movement;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandPermissionException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBeOrSpecifyPlayerException;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"flyspeed"}, description="Set your or another player's fly speed (1-10).", usage="/flyspeed <speed> [player]", permission="essentialz.flyspeed")
public class FlySpeedCommand
extends EszCommand {
    public FlySpeedCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandPermissionException, CommandUsageException, CommandSenderMustBeOrSpecifyPlayerException {
        Player player;
        int speed = 1;
        try {
            if (args.hasArg(0)) {
                speed = args.getInt(0);
            }
        }
        catch (NumberFormatException e) {
            throw new CommandUsageException("/flyspeed <speed> [player]");
        }
        speed = Math.clamp((long)speed, 1, 10);
        Player targetPlayer = args.getPlayer(1, (JavaPlugin)this.getPlugin());
        if (!(targetPlayer == null || sender instanceof Player && (player = (Player)sender).getUniqueId().equals(targetPlayer.getUniqueId()))) {
            if (!Permission.FLYSPEED_OTHERS.has((Permissible)sender)) {
                throw new CommandPermissionException(Permission.FLYSPEED_OTHERS.getNode());
            }
            targetPlayer.setFlySpeed((float)speed / 10.0f);
            this.sendConfirmMessage(targetPlayer, speed);
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.FLYSPEED_SET_OTHER, new MessageManager.Replaceable<String>("{player}", targetPlayer.getName()), new MessageManager.Replaceable<String>("{speed}", String.valueOf(speed))));
            return true;
        }
        if (!(sender instanceof Player)) {
            throw new CommandSenderMustBeOrSpecifyPlayerException();
        }
        player = (Player)sender;
        player.setFlySpeed((float)speed / 10.0f);
        this.sendConfirmMessage(player, speed);
        return true;
    }

    private void sendConfirmMessage(Player player, int speed) {
        player.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.FLYSPEED_SET, new MessageManager.Replaceable<String>("{speed}", String.valueOf(speed))));
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return List.of("1", "2", "3", "4", "5", "6", "7", "8", "9", "10");
        }
        if (args.getCurrentArgIndex() == 1 && Permission.FLYSPEED_OTHERS.has((Permissible)sender)) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

