/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.items;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.EnchantmentManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@AutoRegisterCommand(commands={"enchant"}, description="Apply an enchantment to the item you are holding.", usage="/<command> <enchantment> [level]", permission="essentialz.enchant", aliases={"enchantment"})
public class EnchantCommand
extends EszCommand {
    @InjectManager
    private EnchantmentManager enchantmentManager;

    public EnchantCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandSenderMustBePlayerException, CommandUsageException {
        if (!(sender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)sender;
        ItemStack heldItem = player.getInventory().getItemInMainHand();
        if (heldItem.getType().isAir()) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.MUST_HOLD_AN_ITEM, new MessageManager.Replaceable[0]));
            return false;
        }
        String enchantmentName = args.getArg(0);
        if (enchantmentName == null) {
            throw new CommandUsageException("/<command> <enchantment> [level]");
        }
        Enchantment enchantment = this.enchantmentManager.getEnchantmentByKeyName(enchantmentName);
        if (enchantment == null) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.INVALID_ENCHANTMENT, new MessageManager.Replaceable<String>("{enchantment}", enchantmentName)));
            return false;
        }
        int level = args.getInt(1, enchantment.getMaxLevel());
        heldItem.addUnsafeEnchantment(enchantment, level);
        sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.ENCHANT_SUCCESS, new MessageManager.Replaceable<String>("{enchantment}", enchantment.getKey().getKey()), new MessageManager.Replaceable<String>("{level}", String.valueOf(level))));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return this.getDisplayOptions(this.enchantmentManager.getAllEnchantmentNames(), args.getCurrentArg());
        }
        if (args.getCurrentArgIndex() == 1) {
            Enchantment enchantment = this.enchantmentManager.getEnchantmentByKeyName(args.getArg(0));
            if (enchantment == null) {
                return List.of("1");
            }
            ArrayList<String> levels = new ArrayList<String>();
            for (int i = 1; i <= enchantment.getMaxLevel(); ++i) {
                levels.add(String.valueOf(i));
            }
            return this.getDisplayOptions(levels, args.getCurrentArg());
        }
        return List.of();
    }
}

