/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.communication;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.config.chat.ChatConfig;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.MessageStyle;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBeOrSpecifyPlayerException;
import com.zetaplugins.zetacore.services.config.ConfigService;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"nick"}, description="Set or clear your nickname.", usage="/nick <nickname>", aliases={"nickname", "setnick"}, permission="essentialz.nick")
public class NickCommand
extends EszCommand {
    @InjectManager
    private ConfigService configManager;

    public NickCommand(EssentialZ plugin) {
        super(plugin);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandSenderMustBeOrSpecifyPlayerException {
        nickName = args.getArg(0);
        targetPlayer = args.getPlayer(1, (JavaPlugin)this.getPlugin());
        if (targetPlayer == null && !(sender instanceof Player)) {
            throw new CommandSenderMustBeOrSpecifyPlayerException();
        }
        if (targetPlayer == null) {
            targetPlayer = (Player)sender;
        }
        if (nickName == null || nickName.isEmpty()) {
            targetPlayer.displayName((Component)Component.text((String)targetPlayer.getName()));
            targetPlayer.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.SUCCESS, "nicknameCleared", "&7Your nickname has been {ac}cleared&7.", new MessageManager.Replaceable[0]));
            return true;
        }
        maxNickLenth = this.configManager.getConfig(ChatConfig.class).getMaxNicknameLength();
        if (nickName.length() > maxNickLenth) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ERROR, "nicknameTooLong", "{ac}The nickname is too long! The maximum length is {maxLength} characters.", new MessageManager.Replaceable[]{new MessageManager.Replaceable<String>("{maxLength}", String.valueOf(maxNickLenth))}));
            return false;
        }
        targetPlayer.displayName((Component)Component.text((String)nickName));
        if (!(sender instanceof Player)) ** GOTO lbl-1000
        player = (Player)sender;
        if (targetPlayer.getUniqueId().equals(player.getUniqueId())) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = setForSelf = false;
        }
        if (!setForSelf && !Permission.NICK_OTHERS.has((Permissible)sender)) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ERROR, "notAllowedToNickOthers", "{ac}You do not have permission to set other players' nicknames.", new MessageManager.Replaceable[0]));
            return false;
        }
        if (setForSelf) {
            targetPlayer.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.SUCCESS, "nicknameSetSelf", "&7Your nickname has been set to '{ac}{nickname}&7'.", new MessageManager.Replaceable[]{new MessageManager.Replaceable<String>("{nickname}", nickName)}));
        } else {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.SUCCESS, "nicknameSetOtherConfirm", "&7Set {ac}{player}&7's nickname to '{ac}{nickname}&7'.", new MessageManager.Replaceable[]{new MessageManager.Replaceable<String>("{player}", targetPlayer.getName()), new MessageManager.Replaceable<String>("{nickname}", nickName)}));
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 1 && Permission.NICK_OTHERS.has((Permissible)sender)) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

