/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.updatechecker;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class SemanticVersion
implements Comparable<SemanticVersion>,
Serializable {
    private int major;
    private int minor;
    private int patch;
    private String label;

    public SemanticVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.label = "";
    }

    public SemanticVersion(int major, int minor, int patch, String label) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.label = label != null ? label : "";
    }

    public SemanticVersion(String versionString) {
        if (versionString == null) {
            throw new IllegalArgumentException("versionString must not be null");
        }
        String s = versionString.trim();
        if (s.isEmpty()) {
            throw new IllegalArgumentException("versionString must not be empty");
        }
        if ((s.startsWith("v") || s.startsWith("V")) && (s = s.substring(1).trim()).isEmpty()) {
            throw new IllegalArgumentException("versionString has 'v' but no version numbers");
        }
        String[] mainAndLabel = s.split("-", 2);
        String main = mainAndLabel[0].trim();
        if (main.isEmpty()) {
            throw new IllegalArgumentException("version core (major.minor.patch) is empty");
        }
        String[] parts = main.split("\\.");
        if (parts.length != 3) {
            throw new IllegalArgumentException("version must have major, minor and patch (format: X.Y.Z)");
        }
        try {
            this.major = Integer.parseInt(parts[0].trim());
            this.minor = Integer.parseInt(parts[1].trim());
            this.patch = Integer.parseInt(parts[2].trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("major, minor and patch must be integer numbers", e);
        }
        if (this.major < 0 || this.minor < 0 || this.patch < 0) {
            throw new IllegalArgumentException("major, minor and patch must be non-negative");
        }
        this.label = mainAndLabel.length > 1 ? mainAndLabel[1].trim() : "";
    }

    public int getMajor() {
        return this.major;
    }

    public SemanticVersion setMajor(int major) {
        this.major = major;
        return this;
    }

    public int getMinor() {
        return this.minor;
    }

    public SemanticVersion setMinor(int minor) {
        this.minor = minor;
        return this;
    }

    public int getPatch() {
        return this.patch;
    }

    public SemanticVersion setPatch(int patch) {
        this.patch = patch;
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public SemanticVersion setLabel(String label) {
        this.label = label;
        return this;
    }

    public boolean isGreaterThan(SemanticVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean isLessThan(SemanticVersion other) {
        return this.compareTo(other) < 0;
    }

    @Override
    public int compareTo(@NotNull SemanticVersion o) {
        if (this.major != o.major) {
            return Integer.compare(this.major, o.major);
        }
        if (this.minor != o.minor) {
            return Integer.compare(this.minor, o.minor);
        }
        if (this.patch != o.patch) {
            return Integer.compare(this.patch, o.patch);
        }
        return this.label.compareTo(o.label);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + (String)(this.label != null && !this.label.isEmpty() ? "-" + this.label : "");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion other = (SemanticVersion)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch && (this.label == null && other.label == null || this.label != null && this.label.equals(other.label));
    }

    public int hashCode() {
        int result = Integer.hashCode(this.major);
        result = 31 * result + Integer.hashCode(this.minor);
        result = 31 * result + Integer.hashCode(this.patch);
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }
}

