/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.worldcontrol;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.LanguageManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBeOrSpecifyPlayerException;
import java.util.Arrays;
import java.util.List;
import org.bukkit.WeatherType;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"pweather"}, description="Sets the weather for a specific player", usage="/pweather <clear|rain|reset> <player>", aliases={"playerweather"}, permission="essentialz.pweather")
public class PWeatherCommand
extends EszCommand {
    @InjectManager
    private LanguageManager languageManager;

    public PWeatherCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandException {
        EszWeatherType eszWeatherType = args.getEnumIgnoreCase(0, EszWeatherType.class, EszWeatherType.RESET);
        Player targetPlayer = args.getPlayer(1, sender instanceof Player ? (Player)sender : null, (JavaPlugin)this.getPlugin());
        if (targetPlayer == null) {
            throw new CommandSenderMustBeOrSpecifyPlayerException();
        }
        if (eszWeatherType == EszWeatherType.RESET) {
            targetPlayer.resetPlayerWeather();
            if (sender.equals((Object)targetPlayer)) {
                targetPlayer.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.PWEATHER_RESET, new MessageManager.Replaceable[0]));
            } else {
                sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.PWEATHER_RESET_OTHER, new MessageManager.Replaceable<String>("{player}", targetPlayer.getName())));
            }
            return true;
        }
        targetPlayer.setPlayerWeather(eszWeatherType.getWeatherType());
        if (sender.equals((Object)targetPlayer)) {
            targetPlayer.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.PWEATHER_SET, new MessageManager.Replaceable<String>("{weather}", eszWeatherType.getDisplayName(this.languageManager))));
        } else {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.PWEATHER_SET_OTHER, new MessageManager.Replaceable<String>("{player}", targetPlayer.getName()), new MessageManager.Replaceable<String>("{weather}", eszWeatherType.getDisplayName(this.languageManager))));
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return this.getDisplayOptions(Arrays.stream(EszWeatherType.values()).map(eszWeatherType -> eszWeatherType.name().toLowerCase()).toList(), args.getCurrentArg());
        }
        if (args.getCurrentArgIndex() == 1) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }

    private static enum EszWeatherType {
        CLEAR(WeatherType.CLEAR),
        RAIN(WeatherType.DOWNFALL),
        RESET(null);

        private final WeatherType weatherType;

        private EszWeatherType(WeatherType weatherType) {
            this.weatherType = weatherType;
        }

        public WeatherType getWeatherType() {
            return this.weatherType;
        }

        public String getDisplayName(LanguageManager languageManager) {
            if (this == RESET) {
                return "Reset";
            }
            return languageManager.getString("weather_" + this.name(), this.name().toLowerCase());
        }
    }
}

