/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.movement.homes;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.storage.model.HomeData;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

@AutoRegisterCommand(commands={"home"}, permission="essentialz.home", description="Teleport to your home.", usage="/home <name>")
public class HomeCommand
extends EszCommand {
    @InjectManager
    private Storage storage;

    public HomeCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender commandSender, Command command, String s, ArgumentList args) throws CommandException {
        if (!(commandSender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)commandSender;
        String homeName = args.getArg(0);
        if (homeName == null || homeName.isEmpty()) {
            throw new CommandUsageException("Usage: /home <name>");
        }
        HomeData homeData = this.storage.getHomesRepository().load(player.getUniqueId(), homeName);
        if (homeData == null) {
            commandSender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.HOME_NOT_FOUND, new MessageManager.Replaceable<String>("{homeName}", homeName)));
            return true;
        }
        player.teleport(homeData.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0 && commandSender instanceof Player) {
            Player player = (Player)commandSender;
            return this.getDisplayOptions(this.storage.getHomesRepository().getAllHomes(player.getUniqueId()).stream().map(HomeData::getName).toList(), args.getCurrentArg());
        }
        return List.of();
    }
}

