/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services;

import com.zetaplugins.zetacore.services.LocalizationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;

public final class MessageService {
    private final LocalizationService localizationService;
    private static final Map<String, String> colorMap = new HashMap<String, String>();

    public MessageService(LocalizationService localizationService) {
        this.localizationService = localizationService;
    }

    public static Component formatMsg(String msg, Replaceable<?> ... replaceables) {
        msg = MessageService.replacePlaceholders(msg, replaceables);
        MiniMessage mm = MiniMessage.miniMessage();
        return mm.deserialize((Object)("<!i>" + msg));
    }

    public Component getAndFormatMsg(boolean addPrefix, String path, String fallback, Replaceable<?> ... replaceables) {
        if (path.startsWith("messages.")) {
            path = path.substring("messages.".length());
        }
        MiniMessage mm = MiniMessage.miniMessage();
        Object msg = "<!i>" + this.localizationService.getString(path, fallback);
        String prefix = this.localizationService.getString("prefix", "&8[<gradient:#00D26A:#00B24F>TimberZ&8]");
        msg = !prefix.isEmpty() && addPrefix ? prefix + " " + (String)msg : msg;
        msg = this.replacePlaceholdersWithAccentColors((String)msg, replaceables);
        return mm.deserialize(msg);
    }

    public List<Component> getAndFormatMsgList(String path, Replaceable<?> ... replaceables) {
        if (path.startsWith("messages.")) {
            path = path.substring("messages.".length());
        }
        MiniMessage mm = MiniMessage.miniMessage();
        List<String> msgList = this.localizationService.getStringList(path);
        ArrayList<Component> components = new ArrayList<Component>();
        for (String string : msgList) {
            Object msg = "<!i>" + string;
            msg = this.replacePlaceholdersWithAccentColors((String)msg, replaceables);
            components.add(mm.deserialize(msg));
        }
        return components;
    }

    public String getAccentColor() {
        return this.localizationService.getString("accentColor", "<#00D26A>");
    }

    @NotNull
    public static String replacePlaceholders(String msg, Replaceable<?> ... replaceables) {
        StringBuilder msgBuilder = new StringBuilder(msg);
        for (Replaceable<?> replaceable : replaceables) {
            String placeholder = replaceable.placeholder();
            String value2 = String.valueOf(replaceable.value());
            MessageService.replaceInBuilder(msgBuilder, placeholder, value2);
        }
        colorMap.forEach((key, value) -> MessageService.replaceInBuilder(msgBuilder, key, value));
        return msgBuilder.toString();
    }

    @NotNull
    public String replacePlaceholdersWithAccentColors(String msg, Replaceable<?> ... replaceables) {
        String replacedMsg = MessageService.replacePlaceholders(msg, replaceables);
        StringBuilder msgBuilder = new StringBuilder(replacedMsg);
        MessageService.replaceInBuilder(msgBuilder, "%ac%", this.getAccentColor());
        return msgBuilder.toString();
    }

    public String convertToLegacy(String input) {
        input = input.replace("<black>", "\u00a70");
        input = input.replace("<dark_blue>", "\u00a71");
        input = input.replace("<dark_green>", "\u00a72");
        input = input.replace("<dark_aqua>", "\u00a73");
        input = input.replace("<dark_red>", "\u00a74");
        input = input.replace("<dark_purple>", "\u00a75");
        input = input.replace("<gold>", "\u00a76");
        input = input.replace("<gray>", "\u00a77");
        input = input.replace("<dark_gray>", "\u00a78");
        input = input.replace("<blue>", "\u00a79");
        input = input.replace("<green>", "\u00a7a");
        input = input.replace("<aqua>", "\u00a7b");
        input = input.replace("<red>", "\u00a7c");
        input = input.replace("<light_purple>", "\u00a7d");
        input = input.replace("<yellow>", "\u00a7e");
        input = input.replace("<white>", "\u00a7f");
        input = input.replace("<b>", "\u00a7l");
        input = input.replace("<i>", "\u00a7o");
        input = input.replace("<u>", "\u00a7n");
        input = input.replace("<s>", "\u00a7m");
        input = input.replace("<obf>", "\u00a7k");
        input = input.replace("<bold>", "\u00a7l");
        input = input.replace("<italic>", "\u00a7o");
        input = input.replace("<underlined>", "\u00a7n");
        input = input.replace("<strikethrough>", "\u00a7m");
        input = input.replace("<obfuscated>", "\u00a7k");
        input = input.replace("<!b>", "\u00a7r");
        input = input.replace("<!i>", "\u00a7r");
        input = input.replace("<!u>", "\u00a7r");
        input = input.replace("<!s>", "\u00a7r");
        input = input.replace("<!obf>", "\u00a7r");
        return input;
    }

    private static void replaceInBuilder(StringBuilder builder, String placeholder, String replacement) {
        int index;
        while ((index = builder.indexOf(placeholder)) != -1) {
            builder.replace(index, index + placeholder.length(), replacement);
        }
    }

    static {
        colorMap.put("&0", "<black>");
        colorMap.put("&1", "<dark_blue>");
        colorMap.put("&2", "<dark_green>");
        colorMap.put("&3", "<dark_aqua>");
        colorMap.put("&4", "<dark_red>");
        colorMap.put("&5", "<dark_purple>");
        colorMap.put("&6", "<gold>");
        colorMap.put("&7", "<gray>");
        colorMap.put("&8", "<dark_gray>");
        colorMap.put("&9", "<blue>");
        colorMap.put("&a", "<green>");
        colorMap.put("&b", "<aqua>");
        colorMap.put("&c", "<red>");
        colorMap.put("&d", "<light_purple>");
        colorMap.put("&e", "<yellow>");
        colorMap.put("&f", "<white>");
        colorMap.put("&k", "<obfuscated>");
        colorMap.put("&l", "<bold>");
        colorMap.put("&m", "<strikethrough>");
        colorMap.put("&n", "<underlined>");
        colorMap.put("&o", "<italic>");
        colorMap.put("&r", "<reset>");
    }

    public record Replaceable<T>(String placeholder, T value) {
    }
}

