/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util.gui;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import com.zetaplugins.cookieclickerz.util.NumFormatter;
import com.zetaplugins.cookieclickerz.util.PrestigeData;
import com.zetaplugins.cookieclickerz.util.gui.GuiAssets;
import com.zetaplugins.cookieclickerz.util.items.CustomItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class TopGUI {
    private static final List<UUID> openInventories = new ArrayList<UUID>();
    FileConfiguration config = CookieClickerZ.getInstance().getConfig();

    private TopGUI() {
    }

    public static boolean isOpen(Player player) {
        return openInventories.contains(player.getUniqueId());
    }

    public static void open(Player player) {
        CookieClickerZ plugin = CookieClickerZ.getInstance();
        Inventory inventory = Bukkit.createInventory(null, (int)54, (Component)MessageUtils.getAndFormatMsg(false, "inventories.top.title", "&8Top Players", new MessageUtils.Replaceable[0]));
        GuiAssets.addBorder(inventory);
        GuiAssets.addBackButton(inventory);
        List<PlayerData> topPlayers = plugin.getStorage().getAllPlayers().parallelStream().sorted(Comparator.comparing(PlayerData::getScore).reversed()).limit(10L).collect(Collectors.toList());
        inventory.setItem(13, TopGUI.getTopPlayerItem(plugin, TopGUI.getPlayerOnPosition(topPlayers, 1), 1, "<#FFD700><b>"));
        inventory.setItem(20, TopGUI.getTopPlayerItem(plugin, TopGUI.getPlayerOnPosition(topPlayers, 2), 2, "<#C0C0C0><b>"));
        inventory.setItem(24, TopGUI.getTopPlayerItem(plugin, TopGUI.getPlayerOnPosition(topPlayers, 3), 3, "<#CD7F32><b>"));
        inventory.setItem(37, TopGUI.getTopPlayerItem(plugin, TopGUI.getPlayerOnPosition(topPlayers, 4), 4, "&8"));
        inventory.setItem(38, TopGUI.getTopPlayerItem(plugin, TopGUI.getPlayerOnPosition(topPlayers, 5), 5, "&8"));
        inventory.setItem(39, TopGUI.getTopPlayerItem(plugin, TopGUI.getPlayerOnPosition(topPlayers, 6), 6, "&8"));
        inventory.setItem(40, TopGUI.getTopPlayerItem(plugin, TopGUI.getPlayerOnPosition(topPlayers, 7), 7, "&8"));
        inventory.setItem(41, TopGUI.getTopPlayerItem(plugin, TopGUI.getPlayerOnPosition(topPlayers, 8), 8, "&8"));
        inventory.setItem(42, TopGUI.getTopPlayerItem(plugin, TopGUI.getPlayerOnPosition(topPlayers, 9), 9, "&8"));
        inventory.setItem(43, TopGUI.getTopPlayerItem(plugin, TopGUI.getPlayerOnPosition(topPlayers, 10), 10, "&8"));
        player.openInventory(inventory);
        openInventories.add(player.getUniqueId());
    }

    public static void close(Player player) {
        if (TopGUI.isOpen(player)) {
            openInventories.remove(player.getUniqueId());
        }
    }

    private static ItemStack getTopPlayerItem(CookieClickerZ plugin, @Nullable PlayerData playerData, int place, String placeColor) {
        if (playerData == null) {
            return new CustomItem(Material.SKELETON_SKULL).setName(MessageUtils.getAndFormatMsg(false, "inventories.top.player.title", "%placeColor%#%place% &7%player%", new MessageUtils.Replaceable<String>("%placeColor%", placeColor), new MessageUtils.Replaceable<String>("%place%", String.valueOf(place)), new MessageUtils.Replaceable<String>("%player%", "&8N/A"))).getItemStack();
        }
        return new CustomItem(CustomItem.getHead(playerData.getUuid())).setName(MessageUtils.getAndFormatMsg(false, "inventories.top.player.title", "%placeColor%#%place% &7%player%", new MessageUtils.Replaceable<String>("%placeColor%", placeColor), new MessageUtils.Replaceable<String>("%place%", String.valueOf(place)), new MessageUtils.Replaceable<String>("%player%", playerData.getName()))).setLore(MessageUtils.getAndFormatMsgList("inventories.top.player.description", new MessageUtils.Replaceable<String>("%cookies%", NumFormatter.formatBigInt(playerData.getTotalCookies())), new MessageUtils.Replaceable<String>("%cpc%", NumFormatter.formatBigInt(playerData.getCookiesPerClick())), new MessageUtils.Replaceable<String>("%offlinecookies%", NumFormatter.formatBigInt(playerData.getOfflineCookies())), new MessageUtils.Replaceable<Integer>("%multiplier%", new PrestigeData(plugin, playerData.getPrestige()).getMultiplier()), new MessageUtils.Replaceable<String>("%score%", playerData.getFormattedScore()))).getItemStack();
    }

    @Nullable
    private static PlayerData getPlayerOnPosition(List<PlayerData> topPlayers, int position) {
        return topPlayers.size() < position ? null : topPlayers.get(position - 1);
    }
}

