/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util.cookieevents;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import com.zetaplugins.cookieclickerz.util.cookieevents.CookieEvent;
import com.zetaplugins.cookieclickerz.util.cookieevents.CookieEventType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class CookieEventManager {
    private final CookieClickerZ plugin;
    private final List<CookieEvent> activeEvents = new ArrayList<CookieEvent>();

    public CookieEventManager(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    public void startEvent(@NotNull Player player, @NotNull CookieEventType eventType) {
        CookieEvent event = new CookieEvent(eventType, player.getUniqueId());
        if (eventType.isInstant()) {
            event.runEvent(this.plugin);
        } else {
            event.runEvent(this.plugin);
            this.activeEvents.add(event);
            player.playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
            player.sendMessage(MessageUtils.getAndFormatMsg(true, "eventMessages.start." + eventType.name(), "%ac%&l" + eventType.name() + " &r&7event started!", new MessageUtils.Replaceable[0]));
            this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                this.activeEvents.remove(event);
                player.playSound(player.getLocation(), Sound.BLOCK_BEACON_DEACTIVATE, 1.0f, 1.0f);
                player.sendMessage(MessageUtils.getAndFormatMsg(true, "eventMessages.end." + eventType.name(), "%ac%&l" + eventType.name() + " &r&7event ended!", new MessageUtils.Replaceable[0]));
            }, eventType.getDuration());
        }
    }

    public void startRandomEvent(@NotNull Player player) {
        CookieEventType eventType = CookieEventType.getRandom();
        if (eventType == null) {
            return;
        }
        this.startEvent(player, eventType);
    }

    public List<CookieEvent> getEvents(@NotNull Player player) {
        return this.activeEvents.stream().filter(event -> event.getUuid().equals(player.getUniqueId())).collect(Collectors.toList());
    }

    public boolean hasEvent(@NotNull Player player, @NotNull CookieEventType eventType) {
        return this.getEvents(player).stream().anyMatch(event -> event.getType() == eventType);
    }
}

