/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public final class PricingUtils {
    private static final MathContext MC = new MathContext(50, RoundingMode.HALF_UP);

    private PricingUtils() {
    }

    public static BigInteger priceAtLevel(BigInteger baseBI, double r, int level) {
        if (level < 0) {
            level = 0;
        }
        BigDecimal base = new BigDecimal(baseBI);
        if (r == 1.0) {
            return base.toBigInteger();
        }
        BigDecimal price = base.multiply(PricingUtils.pow(BigDecimal.valueOf(r), level), MC);
        if (price.signum() <= 0) {
            return BigInteger.ZERO;
        }
        return price.setScale(0, RoundingMode.HALF_UP).toBigInteger();
    }

    public static BigInteger totalCostForN(BigInteger baseBI, double r, int currentLevel, int n) {
        if (n <= 0) {
            return BigInteger.ZERO;
        }
        BigDecimal base = new BigDecimal(baseBI);
        if (r == 1.0) {
            BigDecimal first = base.multiply(PricingUtils.pow(BigDecimal.ONE, currentLevel), MC);
            BigDecimal total = first.multiply(BigDecimal.valueOf(n), MC);
            return total.setScale(0, RoundingMode.HALF_UP).toBigInteger();
        }
        BigDecimal rBD = BigDecimal.valueOf(r);
        BigDecimal rPowL = PricingUtils.pow(rBD, currentLevel);
        BigDecimal first = base.multiply(rPowL, MC);
        BigDecimal rn = PricingUtils.pow(rBD, n);
        BigDecimal numerator = rn.subtract(BigDecimal.ONE, MC);
        BigDecimal denominator = rBD.subtract(BigDecimal.ONE, MC);
        BigDecimal sum = first.multiply(numerator, MC).divide(denominator, MC);
        if (sum.signum() <= 0) {
            return BigInteger.ZERO;
        }
        return sum.setScale(0, RoundingMode.HALF_UP).toBigInteger();
    }

    public static BigDecimal pow(BigDecimal a, int n) {
        if (n <= 0) {
            return BigDecimal.ONE;
        }
        BigDecimal result = BigDecimal.ONE;
        BigDecimal base = a;
        for (int exp = n; exp > 0; exp >>= 1) {
            if ((exp & 1) == 1) {
                result = result.multiply(base, MC);
            }
            base = base.multiply(base, MC);
        }
        return result;
    }
}

