/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class LanguageManager {
    private final JavaPlugin plugin;
    public static final List<String> defaultLangs = List.of("en-US", "de-DE", "ru-RU", "cs-CZ");
    private HashMap<String, String> translationMap;
    private FileConfiguration langConfig;

    public LanguageManager(CookieClickerZ plugin) {
        this.plugin = plugin;
        this.loadLanguageConfig();
    }

    public void reload() {
        this.loadLanguageConfig();
    }

    private void loadLanguageConfig() {
        File languageDirectory = new File(this.plugin.getDataFolder(), "lang/");
        if (!languageDirectory.exists() || !languageDirectory.isDirectory()) {
            languageDirectory.mkdir();
        }
        for (String langString : defaultLangs) {
            File langFile = new File("lang/", langString + ".yml");
            if (new File(languageDirectory, langString + ".yml").exists()) continue;
            this.plugin.getLogger().info("Saving file " + langFile.getPath());
            this.plugin.saveResource(langFile.getPath(), false);
        }
        String langOption = this.plugin.getConfig().getString("lang") != null ? this.plugin.getConfig().getString("lang") : "en-US";
        File selectedLangFile = new File(languageDirectory, langOption + ".yml");
        if (!selectedLangFile.exists()) {
            selectedLangFile = new File(languageDirectory, "en-US.yml");
            this.plugin.getLogger().warning("Language file " + langOption + ".yml (" + selectedLangFile.getPath() + ") not found! Using fallback en-US.yml.");
        }
        this.plugin.getLogger().info("Using language file: " + selectedLangFile.getPath());
        this.langConfig = YamlConfiguration.loadConfiguration((File)selectedLangFile);
    }

    public String getString(String key) {
        return this.langConfig.getString(key);
    }

    public String getString(String key, String fallback) {
        return this.langConfig.getString(key) != null ? this.langConfig.getString(key) : fallback;
    }

    public List<String> getStringList(String key) {
        return this.langConfig.getStringList(key);
    }

    public int getInt(String key) {
        return this.langConfig.getInt(key);
    }

    public double getDouble(String key) {
        return this.langConfig.getDouble(key);
    }
}

