/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.storage;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.storage.Storage;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public abstract class SQLStorage
extends Storage {
    private static final String CSV_SEPARATOR = ",";

    public SQLStorage(CookieClickerZ plugin) {
        super(plugin);
    }

    abstract Connection createConnection() throws SQLException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected PlayerData loadPlayerData(Connection connection, UUID uuid) {
        String query = "SELECT * FROM players WHERE uuid = ?";
        if (connection == null) {
            return null;
        }
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM players WHERE uuid = ?");){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) {
                Player player = Bukkit.getPlayer((UUID)uuid);
                if (player == null) {
                    PlayerData playerData = null;
                    return playerData;
                }
                PlayerData newPlayerData = new PlayerData(player.getName(), uuid);
                this.save(newPlayerData);
                PlayerData playerData = newPlayerData;
                return playerData;
            }
            PlayerData playerData = new PlayerData(resultSet.getString("name"), uuid);
            playerData.setTotalCookies(new BigInteger(resultSet.getString("totalCookies")));
            playerData.setTotalClicks(resultSet.getInt("totalClicks"));
            playerData.setLastLogoutTime(resultSet.getLong("lastLogoutTime"));
            playerData.setCookiesPerClick(new BigInteger(resultSet.getString("cookiesPerClick")));
            playerData.setOfflineCookies(new BigInteger(resultSet.getString("offlineCookies")));
            playerData.setPrestige(resultSet.getInt("prestige"));
            PlayerData playerData2 = playerData;
            return playerData2;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to load player data from SQLite database: " + e.getMessage());
            return null;
        }
    }

    protected void loadUpgrades(Connection connection, UUID uuid, PlayerData playerData) {
        String query = "SELECT * FROM upgrades WHERE uuid = ?";
        if (connection == null) {
            return;
        }
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM upgrades WHERE uuid = ?");){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String upgradeName = resultSet.getString("upgrade_name");
                int level = resultSet.getInt("level");
                playerData.addUpgrade(upgradeName, level);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to load upgrades from SQLite database: " + e.getMessage());
        }
    }

    protected void loadAchievements(Connection connection, UUID uuid, PlayerData playerData) {
        String query = "SELECT * FROM achievements WHERE uuid = ?";
        if (connection == null) {
            return;
        }
        try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM achievements WHERE uuid = ?");){
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String achievementSlug = resultSet.getString("achievement_name");
                int progress = resultSet.getInt("progress");
                playerData.setAchievementProgress(achievementSlug, progress);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to load achievements from SQLite database: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String export(String fileName) {
        String filePath = this.getPlugin().getDataFolder().getPath() + "/" + fileName + ".csv";
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                String string = null;
                return string;
            }
            try (Statement statement = connection.createStatement();){
                ResultSet resultSet = statement.executeQuery("SELECT * FROM players");
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
                    while (resultSet.next()) {
                        String line = resultSet.getString("uuid") + CSV_SEPARATOR + resultSet.getString("name") + CSV_SEPARATOR + resultSet.getString("totalCookies") + CSV_SEPARATOR + resultSet.getInt("totalClicks") + CSV_SEPARATOR + resultSet.getLong("lastLogoutTime") + CSV_SEPARATOR + resultSet.getString("cookiesPerClick") + CSV_SEPARATOR + resultSet.getString("offlineCookies") + CSV_SEPARATOR + resultSet.getInt("prestige");
                        writer.write(line);
                        writer.newLine();
                    }
                    return filePath;
                }
            }
            catch (IOException | SQLException e) {
                this.getPlugin().getLogger().severe("Failed to export player data to CSV file: " + e.getMessage());
                String string = null;
                if (connection == null) return string;
                connection.close();
                return string;
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to export player data to CSV file: " + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PlayerData> getAllPlayers() {
        ArrayList<PlayerData> players = new ArrayList<PlayerData>();
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                ArrayList<PlayerData> arrayList = players;
                return arrayList;
            }
            Statement stmt = connection.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT * FROM players");
            while (rs.next()) {
                PlayerData player = new PlayerData(rs.getString("name"), UUID.fromString(rs.getString("uuid")));
                player.setTotalCookies(new BigInteger(rs.getString("totalCookies")));
                player.setTotalClicks(rs.getInt("totalClicks"));
                player.setLastLogoutTime(rs.getLong("lastLogoutTime"));
                player.setCookiesPerClick(new BigInteger(rs.getString("cookiesPerClick")));
                player.setOfflineCookies(new BigInteger(rs.getString("offlineCookies")));
                player.setPrestige(rs.getInt("prestige"));
                players.add(player);
            }
            return players;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to load upgrades from SQLite database: " + e.getMessage());
        }
        return players;
    }
}

