/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.storage;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.storage.SQLStorage;
import com.zetaplugins.cookieclickerz.storage.connectionPool.ConnectionPool;
import com.zetaplugins.cookieclickerz.storage.connectionPool.MySQLConnectionPool;
import com.zetaplugins.cookieclickerz.util.NumFormatter;
import com.zetaplugins.cookieclickerz.util.achievements.Achievement;
import com.zetaplugins.cookieclickerz.util.leaderboard.LeaderBoardEntry;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;

public class MySQLStorage
extends SQLStorage {
    private final Map<UUID, PlayerData> playerDataCache = new ConcurrentHashMap<UUID, PlayerData>();
    private static final String CSV_SEPARATOR = ",";
    private final MySQLConnectionPool connectionPool;

    public MySQLStorage(CookieClickerZ plugin) {
        super(plugin);
        FileConfiguration config = this.getPlugin().getConfig();
        String HOST = config.getString("storage.host");
        String PORT = config.getString("storage.port");
        String DATABASE = config.getString("storage.database");
        String USERNAME = config.getString("storage.username");
        String PASSWORD = config.getString("storage.password");
        this.connectionPool = new MySQLConnectionPool(HOST, PORT, DATABASE, USERNAME, PASSWORD);
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    @Override
    Connection createConnection() throws SQLException {
        return this.getConnectionPool().getConnection();
    }

    @Override
    public void init() {
        try (Connection connection = this.createConnection();){
            Statement statement;
            if (connection == null) {
                return;
            }
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS players (uuid VARCHAR(36) PRIMARY KEY, name VARCHAR(255), totalCookies VARCHAR(255), totalClicks INT, lastLogoutTime BIGINT, cookiesPerClick VARCHAR(255), offlineCookies VARCHAR(255), prestige INT DEFAULT 0)");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS upgrades (uuid VARCHAR(36), upgrade_name VARCHAR(255), level INT, PRIMARY KEY (uuid, upgrade_name), FOREIGN KEY (uuid) REFERENCES players(uuid) ON DELETE CASCADE ON UPDATE CASCADE)");
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS achievements (uuid VARCHAR(36), achievement_name VARCHAR(255), progress INT, PRIMARY KEY (uuid, achievement_name), FOREIGN KEY (uuid) REFERENCES players(uuid) ON DELETE CASCADE ON UPDATE CASCADE)");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to create tables in MySQL database: " + e.getMessage());
            }
            try {
                statement = connection.createStatement();
                try {
                    ResultSet rs = connection.getMetaData().getIndexInfo(null, null, "players", false, false);
                    boolean cookieIndexExists = false;
                    boolean cpcIndexExists = false;
                    while (rs.next()) {
                        String indexName = rs.getString("INDEX_NAME");
                        if ("idx_players_cookie_order".equalsIgnoreCase(indexName)) {
                            cookieIndexExists = true;
                        }
                        if (!"idx_players_cpc_order".equalsIgnoreCase(indexName)) continue;
                        cpcIndexExists = true;
                    }
                    if (!cookieIndexExists) {
                        statement.executeUpdate("CREATE INDEX idx_players_cookie_order ON players (totalCookies)");
                    }
                    if (!cpcIndexExists) {
                        statement.executeUpdate("CREATE INDEX idx_players_cpc_order ON players (cookiesPerClick)");
                    }
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to create indexes in MySQL database: " + e.getMessage());
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to initialize MySQL database: " + e.getMessage());
        }
    }

    @Override
    public void save(PlayerData playerData) {
        if (playerData == null) {
            return;
        }
        if (this.shouldUsePlayerCache() && this.playerDataCache.containsKey(playerData.getUuid())) {
            this.playerDataCache.put(playerData.getUuid(), playerData);
            return;
        }
        String query = "INSERT INTO players (uuid, name, totalCookies, totalClicks, lastLogoutTime, cookiesPerClick, offlineCookies, prestige) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE name = VALUES(name), totalCookies = VALUES(totalCookies), totalClicks = VALUES(totalClicks), lastLogoutTime = VALUES(lastLogoutTime), cookiesPerClick = VALUES(cookiesPerClick), offlineCookies = VALUES(offlineCookies), prestige = VALUES(prestige)";
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                return;
            }
            try (PreparedStatement statement = connection.prepareStatement("INSERT INTO players (uuid, name, totalCookies, totalClicks, lastLogoutTime, cookiesPerClick, offlineCookies, prestige) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE name = VALUES(name), totalCookies = VALUES(totalCookies), totalClicks = VALUES(totalClicks), lastLogoutTime = VALUES(lastLogoutTime), cookiesPerClick = VALUES(cookiesPerClick), offlineCookies = VALUES(offlineCookies), prestige = VALUES(prestige)");){
                statement.setString(1, playerData.getUuid().toString());
                statement.setString(2, playerData.getName());
                statement.setString(3, playerData.getTotalCookies().toString());
                statement.setInt(4, playerData.getTotalClicks());
                statement.setLong(5, playerData.getLastLogoutTime());
                statement.setString(6, playerData.getCookiesPerClick().toString());
                statement.setString(7, playerData.getOfflineCookies().toString());
                statement.setInt(8, playerData.getPrestige());
                statement.executeUpdate();
            }
            this.saveUpgrades(connection, playerData);
            this.saveAchievements(connection, playerData);
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to save player data to MySQL database: " + e.getMessage());
        }
    }

    protected void saveUpgrades(Connection connection, PlayerData playerData) throws SQLException {
        if (playerData.hasRemovedUpgrades()) {
            String deleteQuery = "DELETE FROM upgrades WHERE uuid = ?";
            try (PreparedStatement deleteStatement = connection.prepareStatement("DELETE FROM upgrades WHERE uuid = ?");){
                deleteStatement.setString(1, playerData.getUuid().toString());
                deleteStatement.executeUpdate();
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to delete upgrades for player: " + e.getMessage());
                throw e;
            }
        }
        String query = "INSERT INTO upgrades (uuid, upgrade_name, level) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE level = VALUES(level)";
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO upgrades (uuid, upgrade_name, level) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE level = VALUES(level)");){
            for (Map.Entry<String, Integer> entry : playerData.getUpgrades().entrySet()) {
                statement.setString(1, playerData.getUuid().toString());
                statement.setString(2, entry.getKey());
                statement.setInt(3, entry.getValue());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to save upgrades for player: " + e.getMessage());
            throw e;
        }
    }

    protected void saveAchievements(Connection connection, PlayerData playerData) throws SQLException {
        String query = "INSERT INTO achievements (uuid, achievement_name, progress) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE progress = VALUES(progress)";
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO achievements (uuid, achievement_name, progress) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE progress = VALUES(progress)");){
            for (Achievement achievement : playerData.getAchievements()) {
                statement.setString(1, playerData.getUuid().toString());
                statement.setString(2, achievement.getType().getSlug());
                statement.setInt(3, achievement.getProgress());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to save achievements for player: " + e.getMessage());
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlayerData load(UUID uuid) {
        if (this.shouldUsePlayerCache() && this.playerDataCache.containsKey(uuid)) {
            return this.playerDataCache.get(uuid);
        }
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                PlayerData playerData2 = null;
                return playerData2;
            }
            PlayerData playerData3 = this.loadPlayerData(connection, uuid);
            if (playerData3 != null) {
                this.loadUpgrades(connection, uuid, playerData3);
                this.loadAchievements(connection, uuid, playerData3);
                if (this.shouldUsePlayerCache()) {
                    this.playerDataCache.put(uuid, playerData3);
                    if (this.playerDataCache.size() > this.getMaxCacheSize()) {
                        this.saveAllCachedData();
                    }
                }
            }
            PlayerData playerData = playerData3;
            return playerData;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to load player data from MySQL database: " + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importData(String fileName) {
        String filePath = this.getPlugin().getDataFolder().getPath() + "/" + fileName;
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] data = line.split(CSV_SEPARATOR);
                if (data.length != 8) {
                    this.getPlugin().getLogger().severe("Invalid CSV format.");
                    continue;
                }
                try {
                    Connection connection;
                    block26: {
                        connection = this.createConnection();
                        if (connection != null) break block26;
                        if (connection == null) return;
                        connection.close();
                        return;
                    }
                    try {
                        try {
                            PreparedStatement statement = connection.prepareStatement("INSERT INTO players (uuid, name, totalCookies, totalClicks, lastLogoutTime, cookiesPerClick, offlineCookies, prestige) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE name = VALUES(name), totalCookies = VALUES(totalCookies), totalClicks = VALUES(totalClicks), lastLogoutTime = VALUES(lastLogoutTime), cookiesPerClick = VALUES(cookiesPerClick), offlineCookies = VALUES(offlineCookies), prestige = VALUES(prestige)");
                            try {
                                statement.setString(1, data[0]);
                                statement.setString(2, data[1]);
                                statement.setString(3, data[2]);
                                statement.setInt(4, Integer.parseInt(data[3]));
                                statement.setLong(5, Long.parseLong(data[4]));
                                statement.setString(6, data[5]);
                                statement.setString(7, data[6]);
                                statement.setInt(8, Integer.parseInt(data[7]));
                                statement.executeUpdate();
                            }
                            finally {
                                if (statement == null) continue;
                                statement.close();
                            }
                        }
                        catch (SQLException e) {
                            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to import player data from CSV file: " + e.getMessage(), e);
                        }
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().log(Level.SEVERE, "Failed to import player data from CSV file: " + e.getMessage(), e);
                }
            }
            return;
        }
        catch (IOException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to read CSV file: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<LeaderBoardEntry> getTopCookiesPlayers(int limit) {
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                List<LeaderBoardEntry> list = List.of();
                return list;
            }
            ArrayList<LeaderBoardEntry> topPlayers = new ArrayList<LeaderBoardEntry>();
            String query = "SELECT uuid, name, totalCookies, cookiesPerClick FROM players ORDER BY CHAR_LENGTH(totalCookies) DESC, totalCookies DESC LIMIT ?";
            try (PreparedStatement ps = connection.prepareStatement(query);){
                ps.setInt(1, limit);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        UUID uuid = UUID.fromString(rs.getString("uuid"));
                        String name = rs.getString("name");
                        BigInteger totalCookies = NumFormatter.stringToBigInteger(rs.getString("totalCookies"));
                        BigInteger cpc = NumFormatter.stringToBigInteger(rs.getString("cookiesPerClick"));
                        topPlayers.add(new LeaderBoardEntry(uuid, name, totalCookies, cpc));
                    }
                }
            }
            ArrayList<LeaderBoardEntry> arrayList = topPlayers;
            return arrayList;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to retrieve top players by total cookies from MySQL: " + e.getMessage());
            return List.of();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<LeaderBoardEntry> getTopCpcPlayers(int limit) {
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                List<LeaderBoardEntry> list = List.of();
                return list;
            }
            ArrayList<LeaderBoardEntry> topPlayers = new ArrayList<LeaderBoardEntry>();
            String query = "SELECT uuid, name, totalCookies, cookiesPerClick FROM players ORDER BY CHAR_LENGTH(cookiesPerClick) DESC, cookiesPerClick DESC LIMIT ?";
            try (PreparedStatement ps = connection.prepareStatement(query);){
                ps.setInt(1, limit);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        UUID uuid = UUID.fromString(rs.getString("uuid"));
                        String name = rs.getString("name");
                        BigInteger totalCookies = NumFormatter.stringToBigInteger(rs.getString("totalCookies"));
                        BigInteger cpc = NumFormatter.stringToBigInteger(rs.getString("cookiesPerClick"));
                        topPlayers.add(new LeaderBoardEntry(uuid, name, totalCookies, cpc));
                    }
                }
            }
            ArrayList<LeaderBoardEntry> arrayList = topPlayers;
            return arrayList;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to retrieve top players by CPC from MySQL: " + e.getMessage());
            return List.of();
        }
    }

    @Override
    public void saveAllCachedData() {
        if (this.playerDataCache.isEmpty()) {
            return;
        }
        HashMap<UUID, PlayerData> snapshot = new HashMap<UUID, PlayerData>(this.playerDataCache);
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                return;
            }
            connection.setAutoCommit(false);
            try (PreparedStatement psPlayers = connection.prepareStatement("INSERT INTO players (uuid, name, totalCookies, totalClicks, lastLogoutTime, cookiesPerClick, offlineCookies, prestige) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE name = VALUES(name), totalCookies = VALUES(totalCookies), totalClicks = VALUES(totalClicks), lastLogoutTime = VALUES(lastLogoutTime), cookiesPerClick = VALUES(cookiesPerClick), offlineCookies = VALUES(offlineCookies), prestige = VALUES(prestige)");){
                for (PlayerData data : snapshot.values()) {
                    psPlayers.setString(1, data.getUuid().toString());
                    psPlayers.setString(2, data.getName());
                    psPlayers.setString(3, data.getTotalCookies().toString());
                    psPlayers.setInt(4, data.getTotalClicks());
                    psPlayers.setLong(5, data.getLastLogoutTime());
                    psPlayers.setString(6, data.getCookiesPerClick().toString());
                    psPlayers.setString(7, data.getOfflineCookies().toString());
                    psPlayers.setInt(8, data.getPrestige());
                    psPlayers.addBatch();
                }
                psPlayers.executeBatch();
            }
            for (PlayerData data : snapshot.values()) {
                try {
                    this.saveUpgrades(connection, data);
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().log(Level.WARNING, "Failed to save upgrades for player " + String.valueOf(data.getUuid()) + ": " + e.getMessage(), e);
                }
            }
            try (PreparedStatement psAchievements = connection.prepareStatement("INSERT INTO achievements (uuid, achievement_name, progress) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE progress = VALUES(progress)");){
                for (PlayerData data : snapshot.values()) {
                    for (Achievement achievement : data.getAchievements()) {
                        psAchievements.setString(1, data.getUuid().toString());
                        psAchievements.setString(2, achievement.getType().getSlug());
                        psAchievements.setInt(3, achievement.getProgress());
                        psAchievements.addBatch();
                    }
                }
                psAchievements.executeBatch();
            }
            connection.commit();
            this.playerDataCache.keySet().removeAll(snapshot.keySet());
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to flush player data cache: " + e.getMessage(), e);
        }
    }
}

