/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.storage;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.util.leaderboard.LeaderBoardEntry;
import java.util.List;
import java.util.UUID;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Storage {
    private final CookieClickerZ plugin;

    public Storage(CookieClickerZ plugin) {
        this.plugin = plugin;
        long saveInterval = (long)plugin.getConfig().getInt("enabled.saveInterval", 60) * 20L;
        new BukkitRunnable(){

            public void run() {
                Storage.this.saveAllCachedData();
            }
        }.runTaskTimerAsynchronously((Plugin)plugin, saveInterval, saveInterval);
    }

    protected CookieClickerZ getPlugin() {
        return this.plugin;
    }

    protected boolean shouldUsePlayerCache() {
        return this.getPlugin().getConfig().getBoolean("playerCache.enabled", true);
    }

    protected int getMaxCacheSize() {
        return this.getPlugin().getConfig().getInt("playerCache.maxSize", 1000);
    }

    public abstract void init();

    public abstract void save(PlayerData var1);

    public PlayerData load(String uuid) {
        return this.load(UUID.fromString(uuid));
    }

    public abstract PlayerData load(UUID var1);

    public abstract String export(String var1);

    public abstract void importData(String var1);

    public abstract List<PlayerData> getAllPlayers();

    public abstract List<LeaderBoardEntry> getTopCookiesPlayers(int var1);

    public abstract List<LeaderBoardEntry> getTopCpcPlayers(int var1);

    public abstract void saveAllCachedData();
}

