/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.commands.MainCommand.subcommands;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.commands.CommandUsageException;
import com.zetaplugins.cookieclickerz.commands.SubCommand;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.storage.Storage;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementCategory;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PrestigeSubCommand
implements SubCommand {
    private final CookieClickerZ plugin;

    public PrestigeSubCommand(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) throws CommandUsageException {
        Storage storage = this.plugin.getStorage();
        if (args.length < 2) {
            throw new CommandUsageException("/cc prestige [player] <get, set>");
        }
        String optionTwo = args[1];
        Player target = this.plugin.getServer().getPlayer(optionTwo);
        if (target == null) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "playerNotFound", "&cPlayer not found!", new MessageUtils.Replaceable[0]));
            return false;
        }
        PlayerData targetPlayerData = storage.load(target.getUniqueId());
        if (targetPlayerData == null) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "playerDataStorageNull", "&cPlayerDataStorage is null!", new MessageUtils.Replaceable[0]));
            return false;
        }
        if (args.length < 3) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(true, "getPrestige", "&7%ac%%player%&7's prestige level is %ac%%prestige%", new MessageUtils.Replaceable<String>("%player%", target.getName()), new MessageUtils.Replaceable<Integer>("%prestige%", targetPlayerData.getPrestige())));
            return true;
        }
        String optionThree = args[2];
        if (optionThree.equals("get")) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(true, "getPrestige", "&7%ac%%player%&7's prestige level is %ac%%prestige%", new MessageUtils.Replaceable<String>("%player%", target.getName()), new MessageUtils.Replaceable<Integer>("%prestige%", targetPlayerData.getPrestige())));
            return true;
        }
        if (optionThree.equals("set")) {
            if (args.length < 4) {
                throw new CommandUsageException("/cc prestige [player] set <level>");
            }
            String levelString = args[3];
            int level = Integer.parseInt(levelString);
            if (level < 0) {
                sender.sendMessage(MessageUtils.getAndFormatMsg(false, "negativeAmount", "&cAmount cannot be negative!", new MessageUtils.Replaceable[0]));
                return false;
            }
            targetPlayerData.setPrestige(level);
            for (AchievementType achievementType : AchievementType.getByCategory(AchievementCategory.PRESTIGE)) {
                targetPlayerData.setAchievementProgress(achievementType, level);
            }
            storage.save(targetPlayerData);
            sender.sendMessage(MessageUtils.getAndFormatMsg(true, "setPrestige", "&7Successfully set %ac%%player%&7's prestige level to %ac%%amount%", new MessageUtils.Replaceable<String>("%player%", target.getName()), new MessageUtils.Replaceable<Integer>("%amount%", level)));
            return true;
        }
        return false;
    }

    @Override
    public String getUsage() {
        return "/cc prestige [player] <get, set>";
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("cookieclickerz.admin.manageprestige");
    }
}

