/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz;

import com.zetaplugins.cookieclickerz.storage.MySQLStorage;
import com.zetaplugins.cookieclickerz.storage.SQLiteStorage;
import com.zetaplugins.cookieclickerz.storage.Storage;
import com.zetaplugins.cookieclickerz.util.AntiCheat;
import com.zetaplugins.cookieclickerz.util.ClickerManager;
import com.zetaplugins.cookieclickerz.util.CommandManager;
import com.zetaplugins.cookieclickerz.util.ConfigManager;
import com.zetaplugins.cookieclickerz.util.EventManager;
import com.zetaplugins.cookieclickerz.util.LanguageManager;
import com.zetaplugins.cookieclickerz.util.Metrics;
import com.zetaplugins.cookieclickerz.util.PapiExpansion;
import com.zetaplugins.cookieclickerz.util.VersionChecker;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementManager;
import com.zetaplugins.cookieclickerz.util.cookieevents.CookieEventManager;
import com.zetaplugins.cookieclickerz.util.holograms.DecentHologramManager;
import com.zetaplugins.cookieclickerz.util.holograms.FancyHologramManager;
import com.zetaplugins.cookieclickerz.util.holograms.HologramManager;
import com.zetaplugins.cookieclickerz.util.leaderboard.LeaderBoardService;
import java.io.File;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.java.JavaPlugin;

public final class CookieClickerZ
extends JavaPlugin {
    private static CookieClickerZ instance;
    private VersionChecker versionChecker;
    private Storage storage;
    private LanguageManager languageManager;
    private ConfigManager configManager;
    private AntiCheat antiCheat;
    private HologramManager hologramManager;
    private ClickerManager clickerManager;
    private CookieEventManager cookieEventManager;
    private AchievementManager achievementManager;
    private LeaderBoardService leaderBoardService;
    private final boolean hasPlaceholderApi = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    private final boolean hasDecentHolograms = Bukkit.getPluginManager().getPlugin("DecentHolograms") != null;
    private final boolean hasFancyHolograms = Bukkit.getPluginManager().getPlugin("FancyHolograms") != null;

    public void onEnable() {
        PapiExpansion papiExpansion;
        instance = this;
        this.initConfig();
        this.languageManager = new LanguageManager(this);
        new CommandManager(this).registerCommands();
        new EventManager(this).registerListeners();
        this.storage = this.createStorage();
        this.storage.init();
        this.antiCheat = new AntiCheat(this);
        this.clickerManager = new ClickerManager(this);
        this.cookieEventManager = new CookieEventManager(this);
        this.achievementManager = new AchievementManager(this);
        this.leaderBoardService = new LeaderBoardService(this);
        this.leaderBoardService.start();
        if (this.hasFancyHolograms) {
            this.getLogger().info("FancyHolograms found! Using FancyHolograms for holograms.");
            this.hologramManager = new FancyHologramManager(this);
            this.hologramManager.spawnAllHolograms();
        } else if (this.hasDecentHolograms) {
            this.getLogger().info("DecentHolograms found! Using DecentHolograms for holograms.");
            this.hologramManager = new DecentHologramManager(this);
            this.hologramManager.spawnAllHolograms();
        } else {
            this.getLogger().warning("No hologram plugin found! Holograms will not be displayed.");
        }
        if (this.hasPlaceholderApi() && (papiExpansion = new PapiExpansion(this)).canRegister()) {
            papiExpansion.register();
            this.getLogger().info("PlaceholderAPI found! Enabled PlaceholderAPI support!");
        }
        this.versionChecker = new VersionChecker(this);
        this.initializeBStats();
        this.getLogger().info("CookieClickerZ enabled!");
    }

    public void onDisable() {
        this.storage.saveAllCachedData();
        if (this.hologramManager != null) {
            this.hologramManager.removeAllHolograms();
        }
        this.getLogger().info("CookieClickerZ disabled!");
    }

    public static CookieClickerZ getInstance() {
        return instance;
    }

    public VersionChecker getVersionChecker() {
        return this.versionChecker;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public boolean hasPlaceholderApi() {
        return this.hasPlaceholderApi;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public AntiCheat getAntiCheat() {
        return this.antiCheat;
    }

    public HologramManager getHologramManager() {
        return this.hologramManager;
    }

    public ClickerManager getClickerManager() {
        return this.clickerManager;
    }

    public CookieEventManager getCookieEventManager() {
        return this.cookieEventManager;
    }

    public AchievementManager getAchievementManager() {
        return this.achievementManager;
    }

    public LeaderBoardService getLeaderBoardService() {
        return this.leaderBoardService;
    }

    private Storage createStorage() {
        switch (this.getConfig().getString("storage.type", "sqlite").toLowerCase()) {
            case "mysql": {
                this.getLogger().info("Using MySQL storage");
                return new MySQLStorage(this);
            }
        }
        this.getLogger().info("Using SQLite storage");
        return new SQLiteStorage(this);
    }

    private void initConfig() {
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        for (String file : List.of("upgrades", "prestige", "clicker", "achievements")) {
            this.configManager.getCustomConfig(file);
        }
    }

    private void initializeBStats() {
        int pluginId = 25442;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("storage_type", () -> this.getConfig().getString("storage.type")));
        metrics.addCustomChart(new Metrics.SimplePie("language", () -> this.getConfig().getString("lang")));
    }

    public static String locationToString(Location location) {
        return location.getWorld().getName() + "," + location.getX() + "," + location.getY() + "," + location.getZ();
    }

    public static Location stringToLocation(String string, World world) {
        String[] parts = string.split(",");
        if (parts.length != 4) {
            return null;
        }
        try {
            double x = Double.parseDouble(parts[1]);
            double y = Double.parseDouble(parts[2]);
            double z = Double.parseDouble(parts[3]);
            return new Location(world, x, y, z);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Location stringToLocation(String string) throws IllegalArgumentException {
        String[] parts = string.split(",");
        if (parts.length != 4) {
            throw new IllegalArgumentException("Invalid location string: " + string);
        }
        String worldName = parts[0];
        World world = Bukkit.getWorld((String)worldName);
        if (world == null) {
            throw new IllegalArgumentException("World not found: " + worldName);
        }
        return CookieClickerZ.stringToLocation(string, world);
    }

    public File getPluginFile() {
        return this.getFile();
    }
}

