/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.listeners;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.storage.Storage;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import com.zetaplugins.cookieclickerz.util.NumFormatter;
import java.math.BigInteger;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerJoinListener
implements Listener {
    private final CookieClickerZ plugin;

    public PlayerJoinListener(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getConfig().getBoolean("offlineCookies.enabled", true)) {
            this.grantOfflineCookies(player);
        }
        if (player.isOp() && this.plugin.getConfig().getBoolean("checkForUpdates") && this.plugin.getVersionChecker().NEW_VERSION_AVAILABLE) {
            player.sendMessage(MessageUtils.getAndFormatMsg(true, "newVersionAvailable", "&7A new version of CookieClickerZ is available!\\n%ac%<click:OPEN_URL:https://modrinth.com/plugin/cookieclickerz/versions>https://modrinth.com/plugin/cookieclickerz/versions</click>", new MessageUtils.Replaceable[0]));
        }
    }

    private void grantOfflineCookies(Player player) {
        Storage storage = this.plugin.getStorage();
        PlayerData playerData = storage.load(player.getUniqueId());
        if (playerData == null) {
            PlayerData newPlayerData = new PlayerData(player.getName(), player.getUniqueId());
            storage.save(newPlayerData);
            playerData = newPlayerData;
        }
        long lastLogoutTime = playerData.getLastLogoutTime();
        long currentTime = System.currentTimeMillis();
        long timeDifference = currentTime - lastLogoutTime;
        int timeDifferenceMinutes = (int)(timeDifference / 1000L / 60L);
        if (timeDifferenceMinutes > 0) {
            BigInteger offlineCookies = playerData.getOfflineCookies();
            BigInteger cookiesToAdd = offlineCookies.multiply(BigInteger.valueOf(timeDifferenceMinutes));
            playerData.setTotalCookies(playerData.getTotalCookies().add(cookiesToAdd));
            storage.save(playerData);
            this.plugin.getLogger().info("Player " + player.getName() + " earned " + String.valueOf(cookiesToAdd) + " cookies for being offline for " + timeDifferenceMinutes + " minutes.");
            if (this.plugin.getConfig().getBoolean("offlineCookies.joinMessage", true)) {
                player.sendMessage(MessageUtils.getAndFormatMsg(true, "offlineCookies", "&7You earned &e%ac%%amount%&7 cookies while you were offline!", new MessageUtils.Replaceable<String>("%amount%", NumFormatter.formatBigInt(cookiesToAdd))));
            }
        }
    }
}

