/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util.achievements;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import com.zetaplugins.cookieclickerz.util.achievements.Achievement;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementType;
import java.math.BigInteger;
import org.bukkit.Sound;
import org.bukkit.entity.Player;

public class AchievementManager {
    private final CookieClickerZ plugin;

    public AchievementManager(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    public boolean setAchievementProgress(Player player, Achievement achievement, int progressAmount) {
        if (achievement.isCompleted()) {
            return false;
        }
        achievement.setProgress(progressAmount);
        if (achievement.isCompleted()) {
            this.sendAchievementMessage(player, achievement.getType());
            return true;
        }
        return false;
    }

    public boolean progressAchievement(Player player, Achievement achievement, int progressAmount) {
        if (achievement.isCompleted()) {
            return false;
        }
        achievement.setProgress(achievement.getProgress() + progressAmount);
        if (achievement.isCompleted()) {
            this.sendAchievementMessage(player, achievement.getType());
            return true;
        }
        return false;
    }

    public boolean progressCookiesAchievement(Player player, Achievement achievement, BigInteger totalCookies) {
        if (achievement.isCompleted()) {
            return false;
        }
        if (totalCookies.compareTo(achievement.getType().getBigIntegerGoal()) >= 0) {
            achievement.setProgress(1);
            this.sendAchievementMessage(player, achievement.getType());
            return true;
        }
        return false;
    }

    public void sendAchievementMessage(Player player, AchievementType achievementType) {
        String achievementDescription;
        String achievementName = this.plugin.getLanguageManager().getString("achievements." + achievementType.getSlug() + ".name");
        if (achievementName == null) {
            achievementName = achievementType.getSlug();
        }
        if ((achievementDescription = this.plugin.getLanguageManager().getString("achievements." + achievementType.getSlug() + ".description")) == null) {
            achievementDescription = "No description available";
        }
        player.sendMessage(MessageUtils.getAndFormatMsg(true, "achievementUnlocked", "<#9932cc>&lAchievement! &r&7You unlocked the achievement <hover:show_text:'<#9932cc>%achievement%\n&7%description%'><#9932cc>%achievement%&7!</hover>", new MessageUtils.Replaceable<String>("%achievement%", achievementName), new MessageUtils.Replaceable<String>("%description%", achievementDescription)));
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    protected CookieClickerZ getPlugin() {
        return this.plugin;
    }
}

