/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util.achievements;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import org.bukkit.configuration.file.FileConfiguration;

public enum AchievementCategory {
    CLICKS("clicks"),
    COOKIES("cookies"),
    UPGRADES("upgrades"),
    EVENTS("events"),
    PRESTIGE("prestige"),
    MISC("misc");

    private final String slug;

    private AchievementCategory(String slug) {
        this.slug = slug;
    }

    public String getSlug() {
        return this.slug;
    }

    public String getHeadBase64(CookieClickerZ plugin) {
        FileConfiguration achievementsConfig = plugin.getConfigManager().getAchievementsConfig();
        return achievementsConfig.getString(this.slug + ".head", "none");
    }

    public String toString() {
        return this.slug;
    }

    public static AchievementCategory fromSlug(String slug) {
        for (AchievementCategory category : AchievementCategory.values()) {
            if (!category.slug.equals(slug)) continue;
            return category;
        }
        return null;
    }
}

