/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.util.NumFormatter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class PrestigeData {
    private final int level;
    private final String name;
    private final BigInteger cost;
    private final int multiplier;
    private final List<String> commands;

    public PrestigeData(CookieClickerZ plugin, int level) {
        FileConfiguration config = plugin.getConfigManager().getPrestigeConfig();
        if (level == 0) {
            this.level = 0;
            this.name = "None";
            this.cost = BigInteger.ZERO;
            this.multiplier = 1;
            this.commands = new ArrayList<String>();
            return;
        }
        this.level = level;
        this.name = config.getString("levels." + level + ".name");
        this.cost = NumFormatter.stringToBigInteger(config.getString("levels." + level + ".cost", "0"));
        this.multiplier = config.getInt("levels." + level + ".multiplier");
        this.commands = config.getStringList("levels." + level + ".commands");
    }

    public int getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    public BigInteger getCost() {
        return this.cost;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public List<String> getCommands() {
        return this.commands;
    }
}

