/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final CookieClickerZ plugin;

    public ConfigManager(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    public FileConfiguration getClickerConfig() {
        return this.getCustomConfig("clicker");
    }

    public FileConfiguration getUpgradesConfig() {
        return this.getCustomConfig("upgrades");
    }

    public FileConfiguration getPrestigeConfig() {
        return this.getCustomConfig("prestige");
    }

    public FileConfiguration getAchievementsConfig() {
        return this.getCustomConfig("achievements");
    }

    public FileConfiguration getCustomConfig(String fileName) {
        File configFile = new File(this.plugin.getDataFolder(), (String)(fileName.contains(".yml") ? fileName : fileName + ".yml"));
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            this.plugin.saveResource(fileName + ".yml", false);
        }
        return YamlConfiguration.loadConfiguration((File)configFile);
    }

    public void saveCustomConfig(String fileName, FileConfiguration config) {
        Object name = fileName.contains(".yml") ? fileName : fileName + ".yml";
        File configFile = new File(this.plugin.getDataFolder(), (String)name);
        try {
            config.save(configFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Could not save " + (String)name + ": " + e.getMessage());
        }
    }

    public Map<String, String> getConfigsMap() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("config.yml", this.plugin.getConfig().saveToString());
        configs.put("clicker.yml", this.getClickerConfig().saveToString());
        configs.put("upgrades.yml", this.getUpgradesConfig().saveToString());
        configs.put("prestige.yml", this.getPrestigeConfig().saveToString());
        configs.put("achievements.yml", this.getAchievementsConfig().saveToString());
        return configs;
    }
}

