/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.listeners.inventory;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.storage.Storage;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import com.zetaplugins.cookieclickerz.util.PricingUtils;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementCategory;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementType;
import com.zetaplugins.cookieclickerz.util.gui.GuiAssets;
import com.zetaplugins.cookieclickerz.util.gui.MainGUI;
import com.zetaplugins.cookieclickerz.util.gui.UpgradeGUI;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class UpgradeGuiClickListener
implements Listener {
    private final CookieClickerZ plugin;
    private static final MathContext MC = new MathContext(50, RoundingMode.HALF_UP);

    public UpgradeGuiClickListener(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        BigInteger totalCost;
        Player player = (Player)event.getWhoClicked();
        if (!UpgradeGUI.isOpen(player)) {
            return;
        }
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getItemMeta() == null) {
            return;
        }
        PersistentDataContainer pdc = item.getItemMeta().getPersistentDataContainer();
        String ciType = (String)pdc.get(new NamespacedKey((Plugin)this.plugin, "citype"), PersistentDataType.STRING);
        if (ciType == null) {
            return;
        }
        if (ciType.equals("prev") || ciType.equals("next")) {
            GuiAssets.playClickSound(player);
            Integer pageObj = (Integer)pdc.get(new NamespacedKey((Plugin)this.plugin, "openpage"), PersistentDataType.INTEGER);
            if (pageObj == null) {
                return;
            }
            int targetPage = pageObj;
            if (targetPage < 0) {
                return;
            }
            UpgradeGUI.open(player, targetPage);
            return;
        }
        if (ciType.equals("back")) {
            GuiAssets.playClickSound(player);
            UpgradeGUI.close(player);
            MainGUI.open(player);
            return;
        }
        if (!ciType.equals("upgrade")) {
            return;
        }
        String id = (String)pdc.get(new NamespacedKey((Plugin)this.plugin, "id"), PersistentDataType.STRING);
        if (id == null) {
            return;
        }
        UpgradeGUI.Upgrade upgrade = new UpgradeGUI.Upgrade(id);
        Storage storage = this.plugin.getStorage();
        PlayerData playerData = storage.load(player.getUniqueId());
        int currentLevel = playerData.getUpgradeLevel("upgrade_" + upgrade.getId());
        BigInteger basePriceBI = upgrade.getBaseprice();
        double priceMultiplier = upgrade.getPriceMultiplier();
        int amountToBuy = 1;
        if (event.isRightClick()) {
            amountToBuy = 10;
        }
        if (event.isShiftClick()) {
            BigInteger cookies = playerData.getTotalCookies();
            amountToBuy = this.computeMaxAffordable(basePriceBI, priceMultiplier, currentLevel, cookies);
            if (amountToBuy <= 0) {
                player.sendMessage(MessageUtils.getAndFormatMsg(false, "notEnoughCookies", "&cYou don't have enough cookies!", new MessageUtils.Replaceable[0]));
                player.playSound(player.getLocation(), this.safeSound("errorSound", "ENTITY_VILLAGER_NO"), 1.0f, 1.0f);
                return;
            }
            totalCost = PricingUtils.totalCostForN(basePriceBI, priceMultiplier, currentLevel, amountToBuy);
        } else {
            totalCost = PricingUtils.totalCostForN(basePriceBI, priceMultiplier, currentLevel, amountToBuy);
            if (playerData.getTotalCookies().compareTo(totalCost) < 0) {
                player.sendMessage(MessageUtils.getAndFormatMsg(false, "notEnoughCookies", "&cYou don't have enough cookies!", new MessageUtils.Replaceable[0]));
                player.playSound(player.getLocation(), this.safeSound("errorSound", "ENTITY_VILLAGER_NO"), 1.0f, 1.0f);
                return;
            }
        }
        playerData.setTotalCookies(playerData.getTotalCookies().subtract(totalCost));
        playerData.setCookiesPerClick(playerData.getCookiesPerClick().add(upgrade.getCpc().multiply(BigInteger.valueOf(amountToBuy))));
        playerData.setOfflineCookies(playerData.getOfflineCookies().add(upgrade.getOfflineCookies().multiply(BigInteger.valueOf(amountToBuy))));
        playerData.addUpgrade("upgrade_" + upgrade.getId(), currentLevel + amountToBuy);
        storage.save(playerData);
        player.sendMessage(MessageUtils.getAndFormatMsg(true, "upgradeBought", "&7You bought the upgrade %ac%%upgrade%&7!", new MessageUtils.Replaceable<String>("%upgrade%", upgrade.getName())));
        player.playSound(player.getLocation(), this.safeSound("upgradeSound", "ENTITY_PLAYER_LEVELUP"), 1.0f, 1.0f);
        for (AchievementType achievementType : AchievementType.getByCategory(AchievementCategory.UPGRADES)) {
            playerData.progressAchievement(achievementType, amountToBuy, this.plugin);
            storage.save(playerData);
        }
        UpgradeGUI.close(player);
        UpgradeGUI.open(player);
    }

    private int computeMaxAffordable(BigInteger baseBI, double r, int currentLevel, BigInteger cookies) {
        BigInteger cost;
        if (cookies.signum() <= 0) {
            return 0;
        }
        BigInteger firstPrice = PricingUtils.priceAtLevel(baseBI, r, currentLevel);
        if (cookies.compareTo(firstPrice) < 0) {
            return 0;
        }
        int low = 1;
        int high = 1;
        while ((cost = PricingUtils.totalCostForN(baseBI, r, currentLevel, high)).compareTo(cookies) <= 0 && high <= 1000000000) {
            low = high;
            high = Math.min(high << 1, Integer.MAX_VALUE);
        }
        int left = low;
        int right = high;
        while (left < right) {
            int mid = left + (right - left + 1) / 2;
            BigInteger cost2 = PricingUtils.totalCostForN(baseBI, r, currentLevel, mid);
            if (cost2.compareTo(cookies) <= 0) {
                left = mid;
                continue;
            }
            right = mid - 1;
        }
        return left;
    }

    private Sound safeSound(String configKey, String def) {
        String name = this.plugin.getConfig().getString(configKey, def);
        try {
            return Sound.valueOf((String)name);
        }
        catch (IllegalArgumentException ex) {
            try {
                return Sound.valueOf((String)def);
            }
            catch (IllegalArgumentException ignored) {
                return Sound.ENTITY_PLAYER_LEVELUP;
            }
        }
    }
}

