/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.listeners;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.storage.Storage;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import com.zetaplugins.cookieclickerz.util.NumFormatter;
import com.zetaplugins.cookieclickerz.util.PrestigeData;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementCategory;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementType;
import com.zetaplugins.cookieclickerz.util.cookieevents.CookieEventManager;
import com.zetaplugins.cookieclickerz.util.cookieevents.CookieEventType;
import com.zetaplugins.cookieclickerz.util.gui.MainGUI;
import java.math.BigInteger;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class PlayerInteractionListener
implements Listener {
    private final CookieClickerZ plugin;

    public PlayerInteractionListener(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        if (clickedBlock == null) {
            return;
        }
        Location clickedLocation = clickedBlock.getLocation();
        if (this.plugin.getClickerManager().isClicker(clickedLocation)) {
            if (event.getAction().isLeftClick() && event.getAction() == Action.LEFT_CLICK_BLOCK) {
                this.handleClickerClick(player);
            }
            if (event.getAction().isRightClick() && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                this.handleGuiOpen(player);
            }
        }
    }

    private void handleGuiOpen(Player player) {
        if (!player.hasPermission("cookieclickerz.openmenu")) {
            this.throwPermissionError(player);
            return;
        }
        if (!MainGUI.isOpen(player)) {
            player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 0.3f, 1.0f);
            MainGUI.open(player);
        }
    }

    private void handleClickerClick(Player player) {
        FileConfiguration config = this.plugin.getConfig();
        Storage storage = this.plugin.getStorage();
        if (!player.hasPermission("cookieclickerz.useclicker")) {
            this.throwPermissionError(player);
            return;
        }
        if (config.getBoolean("anticheat.cps.enabled", true) && this.plugin.getAntiCheat().getCps(player.getUniqueId()) >= (double)config.getInt("anticheat.cps.max", 15)) {
            player.sendMessage(MessageUtils.formatMsg(config.getString("anticheat.cps.message", "&cYou are clicking too fast!"), new MessageUtils.Replaceable[0]));
            List commands = config.getStringList("anticheat.cps.commands");
            for (String command : commands) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%player%", player.getName()));
            }
            return;
        }
        Long lastPlayerMove = this.plugin.getAntiCheat().getLastMove(player.getUniqueId());
        long maxTime = (long)config.getInt("anticheat.nomovement.max", 15) * 1000L;
        if (config.getBoolean("anticheat.nomovement.enabled", true) && lastPlayerMove != null && System.currentTimeMillis() - lastPlayerMove > maxTime) {
            player.sendMessage(MessageUtils.formatMsg(config.getString("anticheat.nomovement.message", "&cYou are not moving!"), new MessageUtils.Replaceable[0]));
            player.playSound(player.getLocation(), Sound.valueOf((String)config.getString("errorSound", "ENTITY_VILLAGER_NO")), 1.0f, 1.0f);
            List commands = config.getStringList("anticheat.nomovement.commands");
            for (String command : commands) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%player%", player.getName()));
            }
            return;
        }
        player.playSound(player.getLocation(), Sound.valueOf((String)config.getString("clickSound", "BLOCK_WOODEN_BUTTON_CLICK_ON")), 1.0f, 1.0f);
        PlayerData playerData = storage.load(player.getUniqueId());
        BigInteger cookiesPerClick = playerData.getCookiesPerClick();
        int prestigeMultiplier = new PrestigeData(this.plugin, playerData.getPrestige()).getMultiplier();
        cookiesPerClick = cookiesPerClick.multiply(BigInteger.valueOf(prestigeMultiplier));
        BigInteger originalCookiesPerClick = new BigInteger(cookiesPerClick.toByteArray());
        CookieEventManager cookieEventManager = this.plugin.getCookieEventManager();
        if (cookieEventManager.hasEvent(player, CookieEventType.COOKIE_FRENZY)) {
            cookiesPerClick = cookiesPerClick.multiply(BigInteger.valueOf(7L));
        }
        if (cookieEventManager.hasEvent(player, CookieEventType.CLICK_FRENZY)) {
            cookiesPerClick = cookiesPerClick.multiply(BigInteger.valueOf(777L));
        }
        if (cookieEventManager.hasEvent(player, CookieEventType.CURSED_FINGER)) {
            cookiesPerClick = cookiesPerClick.divide(BigInteger.valueOf(2L));
        }
        playerData.setTotalCookies(playerData.getTotalCookies().add(cookiesPerClick));
        playerData.setTotalClicks(playerData.getTotalClicks() + 1);
        storage.save(playerData);
        String addedCookiesDisplay = cookieEventManager.hasEvent(player, CookieEventType.CURSED_FINGER) ? "<red><st>" + NumFormatter.formatBigInt(originalCookiesPerClick) + "</st></red> " + NumFormatter.formatBigInt(cookiesPerClick) : NumFormatter.formatBigInt(cookiesPerClick);
        this.progressAchievements(this.plugin, player, playerData, cookiesPerClick);
        player.sendActionBar(MessageUtils.getAndFormatMsg(false, "getCookieActionbar", "%ac%+%num% &7%cookieName%&7 &8| %ac%%total% &7%cookieName%&7", new MessageUtils.Replaceable<String>("%num%", addedCookiesDisplay), new MessageUtils.Replaceable<String>("%cookieName%", CookieClickerZ.getInstance().getConfig().getString("cookieName", "<#D2691E>Cookies")), new MessageUtils.Replaceable<String>("%total%", NumFormatter.formatBigInt(playerData.getTotalCookies()))));
        if (this.plugin.getConfig().getBoolean("events.enabled", true) && this.plugin.getCookieEventManager().getEvents(player).isEmpty()) {
            this.plugin.getCookieEventManager().startRandomEvent(player);
        }
    }

    private void throwPermissionError(Player player) {
        Component msg = MessageUtils.getAndFormatMsg(false, "noPermissionError", "&cYou don't have permission to use this!", new MessageUtils.Replaceable[0]);
        player.sendMessage(msg);
    }

    private void progressAchievements(CookieClickerZ plugin, Player player, PlayerData playerData, BigInteger cookiesGained) {
        for (AchievementType achievementType : AchievementType.getByCategory(AchievementCategory.CLICKS)) {
            playerData.progressAchievement(achievementType, 1, plugin);
            plugin.getStorage().save(playerData);
        }
        for (AchievementType achievementType : AchievementType.getByCategory(AchievementCategory.COOKIES)) {
            playerData.progressCookiesAchievement(achievementType, playerData.getTotalCookies(), plugin);
            plugin.getStorage().save(playerData);
        }
    }
}

