/*
 * Decompiled with CFR 0.152.
 */
package me.jsinco.customsaplings.listeners;

import java.util.List;
import java.util.Random;
import me.jsinco.customsaplings.CustomSaplings;
import me.jsinco.customsaplings.Saplings;
import me.jsinco.customsaplings.util.TextUtils;
import me.jsinco.customsaplings.util.Util;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class Events
implements Listener {
    private final CustomSaplings plugin;

    public Events(CustomSaplings plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        ItemStack item = event.getItemInHand();
        if (!item.hasItemMeta() || !item.getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "schematic"), PersistentDataType.STRING)) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("require-permission-to-place") && !event.getPlayer().hasPermission("customsaplings.place")) {
            event.getPlayer().sendMessage(TextUtils.prefix + "You do not have permission to place this sapling!");
            event.setCancelled(true);
            return;
        }
        String schematic = (String)item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "schematic"), PersistentDataType.STRING);
        String sapling = (String)item.getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "sapling"), PersistentDataType.STRING);
        event.getBlockPlaced().setMetadata("schematic", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)schematic));
        event.getBlockPlaced().setMetadata("sapling", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)sapling));
        Util.log("&a" + event.getPlayer().getName() + " placed a " + sapling + " sapling!");
    }

    @EventHandler(ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        List blocks = event.getBlocks();
        for (BlockState block : blocks) {
            if (!block.hasMetadata("schematic")) continue;
            Block cloneBlock = block.getBlock();
            List metadataValues = block.getMetadata("schematic");
            String schematic = ((MetadataValue)metadataValues.get(0)).asString();
            cloneBlock.removeMetadata("schematic", (Plugin)this.plugin);
            cloneBlock.removeMetadata("sapling", (Plugin)this.plugin);
            cloneBlock.setType(Material.AIR);
            Saplings.setSchematic(schematic, cloneBlock);
            event.setCancelled(true);
            Util.log("&aA " + schematic + " tree has grown!");
            break;
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (!block.hasMetadata("sapling")) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("drop-sapling-item-on-break")) {
            return;
        }
        List metadataValues = block.getMetadata("sapling");
        ItemStack sapling = Saplings.getSapling(((MetadataValue)metadataValues.get(0)).asString());
        if (sapling == null) {
            return;
        }
        if (!block.getType().equals((Object)sapling.getType())) {
            block.removeMetadata("sapling", (Plugin)this.plugin);
            block.removeMetadata("schematic", (Plugin)this.plugin);
            return;
        }
        if (this.plugin.getConfig().getBoolean("require-permission-to-break") && !event.getPlayer().hasPermission("customsaplings.break")) {
            event.getPlayer().sendMessage(TextUtils.prefix + "You do not have permission to break this sapling!");
            Util.log("&e" + event.getPlayer().getName() + " tried to break a sapling but did not have permission! Location: " + event.getPlayer().getLocation());
            event.setCancelled(true);
            return;
        }
        event.setDropItems(false);
        block.getWorld().dropItemNaturally(block.getLocation(), sapling);
        Util.log("&a" + event.getPlayer().getName() + " broke a " + ((MetadataValue)metadataValues.get(0)).asString() + " sapling!");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_AIR) && !event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        if (event.getItem() == null || !event.getItem().hasItemMeta() || !event.getItem().getItemMeta().getPersistentDataContainer().has(new NamespacedKey((Plugin)this.plugin, "box"), PersistentDataType.STRING)) {
            return;
        }
        String rarity = (String)event.getItem().getItemMeta().getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "box"), PersistentDataType.STRING);
        List<String> saplings = Saplings.getAllSaplingsOfRarity(rarity);
        if (saplings.isEmpty()) {
            event.getPlayer().sendMessage(TextUtils.prefix + "There are no saplings in this box!");
            Util.log("&eSomeone tried to open a box with no saplings in it! Rarity: " + rarity + " Location: " + event.getPlayer().getLocation());
        } else {
            event.getItem().setAmount(event.getItem().getAmount() - 1);
            String sapling = saplings.get(new Random().nextInt(saplings.size()));
            Util.giveItem(event.getPlayer(), Saplings.getSapling(sapling));
            Util.log("&a" + event.getPlayer().getName() + " opened a " + rarity + " box and got a " + sapling + " sapling!");
            if (this.plugin.getConfig().get("rarity-boxes." + rarity + ".open-sound") != null) {
                event.getPlayer().playSound(event.getPlayer().getLocation(), Sound.valueOf((String)this.plugin.getConfig().getString("rarity-boxes." + rarity + ".open-sound")), 1.0f, 1.0f);
            }
        }
        event.setCancelled(true);
    }
}

