/*
 * Decompiled with CFR 0.152.
 */
package me.jsinco.customsaplings.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.jsinco.customsaplings.CustomSaplings;
import me.jsinco.customsaplings.commands.BoxCommand;
import me.jsinco.customsaplings.commands.GiveCommand;
import me.jsinco.customsaplings.commands.HelpCommand;
import me.jsinco.customsaplings.commands.PasteCommand;
import me.jsinco.customsaplings.commands.ReloadCommand;
import me.jsinco.customsaplings.commands.SubCommand;
import me.jsinco.customsaplings.commands.VerboseCommand;
import me.jsinco.customsaplings.util.TextUtils;
import me.jsinco.customsaplings.util.Util;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class CommandManager
implements CommandExecutor,
TabCompleter {
    private final CustomSaplings plugin;
    private final Map<String, SubCommand> subCommands = new HashMap<String, SubCommand>();

    public CommandManager(CustomSaplings plugin) {
        this.plugin = plugin;
        this.subCommands.put("help", new HelpCommand());
        this.subCommands.put("paste", new PasteCommand());
        this.subCommands.put("give", new GiveCommand());
        this.subCommands.put("reload", new ReloadCommand());
        this.subCommands.put("box", new BoxCommand());
        this.subCommands.put("verbose", new VerboseCommand());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length < 1) {
            Util.log("&a" + sender.getName() + " executed /customsaplings");
            sender.sendMessage(TextUtils.prefix + "Custom Saplings v" + this.plugin.getDescription().getVersion() + " by " + (String)this.plugin.getDescription().getAuthors().get(0));
            return true;
        }
        args[0] = args[0].toLowerCase();
        Util.log("&a" + sender.getName() + " executed /customsaplings " + String.join((CharSequence)" ", args));
        if (!this.subCommands.containsKey(args[0])) {
            sender.sendMessage(TextUtils.prefix + "Unknown subcommand!");
            this.subCommands.get("help").execute(this.plugin, sender, args);
            return true;
        }
        SubCommand subCommand = this.subCommands.get(args[0]);
        subCommand.execute(this.plugin, sender, args);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("customsaplings.tabcomplete")) {
            return null;
        }
        if (args.length == 1) {
            return this.subCommands.keySet().stream().toList();
        }
        SubCommand subCommand = this.subCommands.get(args[0]);
        if (subCommand != null) {
            return subCommand.tabComplete(this.plugin, sender, args);
        }
        return null;
    }
}

