/*
 * Decompiled with CFR 0.152.
 */
package me.jsinco.customsaplings;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.world.World;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.bukkit.Location;

public record Schematic(Clipboard clipboard) {
    public void paste(Location target) {
        World world = BukkitAdapter.adapt((org.bukkit.World)target.getWorld());
        com.sk89q.worldedit.util.Location location = BukkitAdapter.adapt((Location)target);
        EditSession session = WorldEdit.getInstance().getEditSessionFactory().getEditSession(world, -1);
        Operation operation = new ClipboardHolder(this.clipboard).createPaste((Extent)session).to(location.toVector().toBlockPoint()).ignoreAirBlocks(true).build();
        try {
            Operations.complete((Operation)operation);
            session.close();
        }
        catch (WorldEditException exception) {
            exception.printStackTrace();
        }
    }

    public static Optional<Schematic> load(File file) {
        Optional<Schematic> optional;
        block9: {
            ClipboardFormat format = ClipboardFormats.findByFile((File)file);
            if (format == null) {
                return Optional.empty();
            }
            ClipboardReader reader = format.getReader((InputStream)new FileInputStream(file));
            try {
                optional = Optional.of(new Schematic(reader.read()));
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    exception.printStackTrace();
                    return Optional.empty();
                }
            }
            reader.close();
        }
        return optional;
    }
}

