/*
 * Decompiled with CFR 0.152.
 */
package me.jsinco.customsaplings;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import me.jsinco.customsaplings.CustomSaplings;
import me.jsinco.customsaplings.configupdater.ConfigUpdater;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class FileManager {
    File[] schematics;
    private final CustomSaplings plugin;

    public FileManager(CustomSaplings plugin) {
        this.plugin = plugin;
    }

    public void loadSchematicFiles() {
        File schematicsFolder = new File(this.plugin.getDataFolder(), "Schematics");
        if (!schematicsFolder.exists()) {
            schematicsFolder.mkdir();
        }
        this.schematics = schematicsFolder.listFiles();
        if (this.schematics != null && this.schematics.length == 0) {
            this.loadDefaultSchematics();
        }
    }

    public void loadDefaultSchematics() {
        String[] defaultSchematics;
        for (String fileName : defaultSchematics = new String[]{"gray_tree.schem", "maple_tree.schem", "mushpeach_cherrytree.schem", "bigtree.schem"}) {
            File file = new File(this.plugin.getDataFolder(), "Schematics" + File.separator + fileName);
            try {
                int bytesRead;
                if (file.exists()) continue;
                file.createNewFile();
                InputStream inputStream = this.plugin.getResource("Schematics" + File.separator + fileName);
                OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                inputStream.close();
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static File getSchematicFile(CustomSaplings plugin, String schematicName) {
        File schemFile = new File(plugin.getDataFolder(), "Schematics" + File.separator + schematicName);
        if (!schemFile.exists()) {
            return null;
        }
        return schemFile;
    }

    public static File getSchematicFileFromWE(CustomSaplings plugin, String schematicName) {
        String filePath = new File(plugin.getDataFolder().getParent() + File.separator + "WorldEdit").exists() ? plugin.getDataFolder().getParent() + File.separator + "WorldEdit" + File.separator + "schematics" + File.separator + schematicName : plugin.getDataFolder().getParent() + File.separator + "FastAsyncWorldEdit" + File.separator + "schematics" + File.separator + schematicName;
        File schemFile = new File(filePath);
        if (!schemFile.exists()) {
            return null;
        }
        return schemFile;
    }

    public void loadSaplingsFile() {
        File saplingsFile = new File(this.plugin.getDataFolder(), "saplings.yml");
        try {
            if (!saplingsFile.exists()) {
                int bytesRead;
                saplingsFile.createNewFile();
                InputStream inputStream = this.plugin.getResource("saplings.yml");
                OutputStream outputStream = Files.newOutputStream(saplingsFile.toPath(), new OpenOption[0]);
                byte[] buffer = new byte[1024];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                inputStream.close();
                outputStream.flush();
                outputStream.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static YamlConfiguration getSaplingsFile(CustomSaplings plugin) {
        return YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "saplings.yml"));
    }

    public boolean updateFile(String fileName) {
        File file = new File(this.plugin.getDataFolder(), fileName);
        if (!file.exists()) {
            return false;
        }
        try {
            ConfigUpdater.update((Plugin)this.plugin, fileName, file, List.of());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void loadDefaultConfig(boolean reload) {
        if (!reload) {
            this.plugin.getConfig().options().copyDefaults(true);
            this.plugin.saveDefaultConfig();
        } else {
            this.plugin.reloadConfig();
        }
    }
}

