/*
 * Decompiled with CFR 0.152.
 */
package com.jotrorox.shop.manager;

import com.jotrorox.shop.SleepyShop;
import com.jotrorox.shop.model.Shop;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ShopManager {
    private final JavaPlugin plugin;
    private final Map<String, Shop> shops = new HashMap<String, Shop>();

    public ShopManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.migrateIfNecessary();
        this.loadShops();
    }

    private void migrateIfNecessary() {
        File yamlFile = new File(this.plugin.getDataFolder(), "shops.yml");
        if (yamlFile.exists()) {
            this.plugin.getLogger().info("Found shops.yml, migrating to SQLite...");
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)yamlFile);
            for (String key : config.getKeys(false)) {
                ConfigurationSection section = config.getConfigurationSection(key);
                if (section == null) continue;
                Location signLoc = section.getLocation("sign");
                Location chestLoc = section.getLocation("chest");
                String ownerStr = section.getString("owner");
                if (signLoc == null || chestLoc == null || ownerStr == null) continue;
                Shop shop = new Shop(signLoc, chestLoc, UUID.fromString(ownerStr));
                shop.setSellItem(section.getItemStack("item"));
                shop.setPaymentItem(section.getItemStack("paymentItem", new ItemStack(Material.DIAMOND)));
                shop.setTakeAmount(section.getInt("price"));
                shop.setOutputAmount(section.getInt("amount", 1));
                shop.setShopName(section.getString("shopName"));
                shop.setShowDisplay(section.getBoolean("showDisplay", true));
                shop.setShowStockMessage(section.getBoolean("showStockMessage", true));
                String displayIdStr = section.getString("displayId");
                if (displayIdStr != null) {
                    shop.setDisplayEntityId(UUID.fromString(displayIdStr));
                }
                ((SleepyShop)this.plugin).getDatabaseManager().saveShop(shop).join();
            }
            yamlFile.renameTo(new File(this.plugin.getDataFolder(), "shops.yml.bak"));
            this.plugin.getLogger().info("Migration complete! shops.yml renamed to shops.yml.bak");
        }
    }

    private void loadShops() {
        ((SleepyShop)this.plugin).getDatabaseManager().loadShops().thenAccept(loadedShops -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            for (Shop shop : loadedShops) {
                this.shops.put(this.locationToString(shop.getSignLocation()), shop);
                this.updateDisplay(shop);
            }
        }));
    }

    public void saveShop(Shop shop) {
        String id = this.locationToString(shop.getSignLocation());
        this.shops.put(id, shop);
        ((SleepyShop)this.plugin).getDatabaseManager().saveShop(shop).thenRun(() -> Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.updateDisplay(shop)));
    }

    public void removeShop(Location signLoc) {
        Entity entity;
        String id = this.locationToString(signLoc);
        Shop shop = this.shops.remove(id);
        if (shop != null && shop.getDisplayEntityId() != null && (entity = Bukkit.getEntity((UUID)shop.getDisplayEntityId())) != null) {
            entity.remove();
        }
        ((SleepyShop)this.plugin).getDatabaseManager().removeShop(signLoc);
    }

    public void updateDisplay(Shop shop) {
        Chest chest;
        Inventory chestInv;
        Block chestBlock;
        BlockState blockState;
        Object entity;
        if (!Bukkit.isPrimaryThread()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.updateDisplay(shop));
            return;
        }
        if (shop.getChestLocation() == null || shop.getChestLocation().getWorld() == null) {
            return;
        }
        Location loc = shop.getChestLocation().clone().add(0.5, 1.2, 0.5);
        if (!loc.isChunkLoaded()) {
            return;
        }
        if (!shop.isShowDisplay()) {
            if (shop.getDisplayEntityId() != null) {
                Entity entity2 = Bukkit.getEntity((UUID)shop.getDisplayEntityId());
                if (entity2 != null) {
                    entity2.remove();
                }
                shop.setDisplayEntityId(null);
                ((SleepyShop)this.plugin).getDatabaseManager().saveShop(shop);
            }
            return;
        }
        TextDisplay display = null;
        if (shop.getDisplayEntityId() != null && (entity = Bukkit.getEntity((UUID)shop.getDisplayEntityId())) instanceof TextDisplay) {
            TextDisplay td;
            display = td = (TextDisplay)entity;
        }
        if (display == null) {
            for (Entity nearby : loc.getWorld().getNearbyEntities(loc, 0.1, 0.1, 0.1)) {
                TextDisplay td;
                if (!(nearby instanceof TextDisplay)) continue;
                display = td = (TextDisplay)nearby;
                shop.setDisplayEntityId(display.getUniqueId());
                ((SleepyShop)this.plugin).getDatabaseManager().saveShop(shop);
                break;
            }
        }
        if (display == null) {
            display = (TextDisplay)loc.getWorld().spawn(loc, TextDisplay.class);
            shop.setDisplayEntityId(display.getUniqueId());
            display.setBillboard(Display.Billboard.CENTER);
            ((SleepyShop)this.plugin).getDatabaseManager().saveShop(shop);
        } else {
            display.teleport(loc);
        }
        String ownerName = Bukkit.getOfflinePlayer((UUID)shop.getOwner()).getName();
        if (ownerName == null) {
            ownerName = "Unknown";
        }
        String shopName = shop.getShopName();
        String sellItemName = shop.getSellItem() != null ? shop.getSellItem().getType().name() : "None";
        String payItemName = shop.getPaymentItem() != null ? shop.getPaymentItem().getType().name() : "None";
        boolean outOfStock = false;
        if (shop.getSellItem() != null && (blockState = (chestBlock = shop.getChestLocation().getBlock()).getState()) instanceof Chest && !(chestInv = (chest = (Chest)blockState).getInventory()).containsAtLeast(shop.getSellItem(), shop.getOutputAmount())) {
            outOfStock = true;
        }
        FileConfiguration pluginConfig = this.plugin.getConfig();
        MiniMessage mm = MiniMessage.miniMessage();
        String titleStr = shopName != null && !shopName.isEmpty() ? pluginConfig.getString("shop-display.custom-title", "<gold><b>{shopname}</b>").replace("{shopname}", shopName) : pluginConfig.getString("shop-display.title", "<gold><b>{owner}'s Shop</b>").replace("{owner}", ownerName);
        Component title = mm.deserialize((Object)titleStr);
        Component selling = mm.deserialize((Object)pluginConfig.getString("shop-display.selling", "<white>Selling: <green>{amount}x {item}").replace("{amount}", String.valueOf(shop.getOutputAmount())).replace("{item}", sellItemName));
        Component price = mm.deserialize((Object)pluginConfig.getString("shop-display.price", "<white>Price: <aqua>{price}x {payitem}").replace("{price}", String.valueOf(shop.getTakeAmount())).replace("{payitem}", payItemName));
        Component text = title.append((Component)Component.newline()).append(selling).append((Component)Component.newline()).append(price);
        if (outOfStock && shop.isShowStockMessage()) {
            text = text.append((Component)Component.newline()).append(mm.deserialize((Object)pluginConfig.getString("shop-display.out-of-stock", "<red><b>OUT OF STOCK</b>")));
        }
        display.text(text);
    }

    public Shop getShop(Location signLoc) {
        return this.shops.get(this.locationToString(signLoc));
    }

    public Map<String, Shop> getShops() {
        return this.shops;
    }

    public boolean isShopSign(Location loc) {
        return this.shops.containsKey(this.locationToString(loc));
    }

    private String locationToString(Location loc) {
        if (loc == null || loc.getWorld() == null) {
            return "null";
        }
        return loc.getWorld().getName() + "_" + loc.getBlockX() + "_" + loc.getBlockY() + "_" + loc.getBlockZ();
    }
}

