/*
 * Decompiled with CFR 0.152.
 */
package com.jotrorox.shop.listener;

import com.jotrorox.shop.manager.ShopManager;
import com.jotrorox.shop.model.Shop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Directional;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;

public class SignListener
implements Listener {
    private final ShopManager manager;
    private static final Component PREFIX = Component.text((String)"[SleepyShop] ", (TextColor)NamedTextColor.BLUE);

    public SignListener(ShopManager manager) {
        this.manager = manager;
    }

    @EventHandler
    public void onSignChange(SignChangeEvent event) {
        String line1 = PlainTextComponentSerializer.plainText().serialize(event.line(0));
        if (line1.equalsIgnoreCase("[Shop]") || line1.equalsIgnoreCase("[SleepyShop]")) {
            Block signBlock = event.getBlock();
            Block chestBlock = this.findAttachedChest(signBlock);
            if (chestBlock == null) {
                event.getPlayer().sendMessage(PREFIX.append((Component)Component.text((String)"No chest found nearby!", (TextColor)NamedTextColor.RED)));
                return;
            }
            Shop shop = new Shop(signBlock.getLocation(), chestBlock.getLocation(), event.getPlayer().getUniqueId());
            this.manager.saveShop(shop);
            event.line(0, (Component)Component.text((String)"[SleepyShop]", (TextColor)NamedTextColor.BLUE));
            event.getPlayer().sendMessage(PREFIX.append((Component)Component.text((String)"SleepyShop created!", (TextColor)NamedTextColor.GREEN)));
        }
    }

    private Block findAttachedChest(Block signBlock) {
        BlockFace[] faces;
        Directional directional;
        Block attachedTo;
        BlockFace[] blockFaceArray = signBlock.getBlockData();
        if (blockFaceArray instanceof Directional && this.isChest(attachedTo = signBlock.getRelative((directional = (Directional)blockFaceArray).getFacing().getOppositeFace()))) {
            return attachedTo;
        }
        for (BlockFace face : faces = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN}) {
            Block relative = signBlock.getRelative(face);
            if (!this.isChest(relative)) continue;
            return relative;
        }
        return null;
    }

    private boolean isChest(Block block) {
        return block.getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST || block.getType() == Material.BARREL;
    }
}

