/*
 * Decompiled with CFR 0.152.
 */
package com.jotrorox.shop.listener;

import com.jotrorox.shop.gui.ShopGuiProvider;
import com.jotrorox.shop.gui.ShopInventoryHolder;
import com.jotrorox.shop.manager.ShopManager;
import com.jotrorox.shop.model.Shop;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Container;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class ShopListener
implements Listener {
    private final ShopManager manager;
    private final ShopGuiProvider guiProvider;
    private final Map<UUID, Shop> namingSession = new HashMap<UUID, Shop>();
    private static final Component PREFIX = Component.text((String)"[SleepyShop] ", (TextColor)NamedTextColor.BLUE);

    public ShopListener(ShopManager manager) {
        this.manager = manager;
        this.guiProvider = new ShopGuiProvider();
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        this.manager.getShops().values().stream().filter(shop -> shop.getChestLocation().getWorld().equals((Object)event.getWorld())).filter(shop -> shop.getChestLocation().getBlockX() >> 4 == event.getChunk().getX() && shop.getChestLocation().getBlockZ() >> 4 == event.getChunk().getZ()).forEach(this.manager::updateDisplay);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Location loc = event.getBlock().getLocation();
        if (this.manager.isShopSign(loc)) {
            Shop shop = this.manager.getShop(loc);
            if (!event.getPlayer().getUniqueId().equals(shop.getOwner()) && !event.getPlayer().isOp()) {
                event.setCancelled(true);
                event.getPlayer().sendMessage(PREFIX.append((Component)Component.text((String)"You cannot break this shop!", (TextColor)NamedTextColor.RED)));
            } else {
                this.manager.removeShop(loc);
                event.getPlayer().sendMessage(PREFIX.append((Component)Component.text((String)"SleepyShop removed.", (TextColor)NamedTextColor.YELLOW)));
            }
        } else if (this.isChest(event.getBlock())) {
            for (Shop shop : this.manager.getShops().values()) {
                if (!this.isSameChest(shop.getChestLocation().getBlock(), event.getBlock())) continue;
                if (!event.getPlayer().getUniqueId().equals(shop.getOwner()) && !event.getPlayer().isOp()) {
                    event.setCancelled(true);
                    event.getPlayer().sendMessage(PREFIX.append((Component)Component.text((String)"This chest belongs to a shop!", (TextColor)NamedTextColor.RED)));
                }
                return;
            }
        }
    }

    @EventHandler
    public void onChestAccess(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !this.isChest(block)) {
            return;
        }
        for (Shop shop : this.manager.getShops().values()) {
            if (!this.isSameChest(shop.getChestLocation().getBlock(), block)) continue;
            if (!event.getPlayer().getUniqueId().equals(shop.getOwner()) && !event.getPlayer().isOp()) {
                event.setCancelled(true);
                event.getPlayer().sendMessage(PREFIX.append((Component)Component.text((String)"This chest belongs to a shop!", (TextColor)NamedTextColor.RED)));
            }
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Container container;
        Block block;
        Inventory inv = event.getInventory();
        InventoryHolder inventoryHolder = inv.getHolder();
        if (inventoryHolder instanceof Container && this.isChest(block = (container = (Container)inventoryHolder).getBlock())) {
            for (Shop shop : this.manager.getShops().values()) {
                if (!this.isSameChest(shop.getChestLocation().getBlock(), block)) continue;
                this.manager.updateDisplay(shop);
                return;
            }
        }
    }

    private boolean isChest(Block block) {
        return block.getType() == Material.CHEST || block.getType() == Material.TRAPPED_CHEST || block.getType() == Material.BARREL;
    }

    private boolean isSameChest(Block shopChest, Block target) {
        if (shopChest.equals((Object)target)) {
            return true;
        }
        BlockState blockState = shopChest.getState();
        if (blockState instanceof Chest) {
            Chest c1 = (Chest)blockState;
            blockState = target.getState();
            if (blockState instanceof Chest) {
                Chest c2 = (Chest)blockState;
                return c1.getInventory().equals((Object)c2.getInventory());
            }
        }
        return false;
    }

    @EventHandler
    public void onSignClick(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !(block.getState() instanceof Sign)) {
            return;
        }
        Shop shop = this.manager.getShop(block.getLocation());
        if (shop != null) {
            event.setCancelled(true);
            if (event.getPlayer().getUniqueId().equals(shop.getOwner())) {
                this.guiProvider.openOwnerGui(event.getPlayer(), shop);
            } else {
                this.guiProvider.openBuyerGui(event.getPlayer(), shop);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryHolder inventoryHolder = event.getInventory().getHolder();
        if (!(inventoryHolder instanceof ShopInventoryHolder)) {
            return;
        }
        ShopInventoryHolder holder = (ShopInventoryHolder)inventoryHolder;
        Player player = (Player)event.getWhoClicked();
        Shop shop = holder.getShop();
        String title = holder.getTitle();
        if (event.getClickedInventory() == event.getView().getTopInventory()) {
            event.setCancelled(true);
            if (title.equals("Purchase Item")) {
                this.handleBuyerClick(event, player, shop);
            } else {
                this.handleOwnerClick(event, player, shop, title);
            }
        } else if (title.equals("Shop Item Settings")) {
            if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                event.setCancelled(true);
            }
        } else {
            event.setCancelled(true);
        }
    }

    private void handleOwnerClick(InventoryClickEvent event, Player player, Shop shop, String title) {
        int slot = event.getRawSlot();
        if (title.equals("SleepyShop Configuration")) {
            if (slot == 11) {
                this.guiProvider.openPriceGui(player, shop);
            } else if (slot == 13) {
                this.guiProvider.openItemsGui(player, shop);
            } else if (slot == 15) {
                this.guiProvider.openOtherGui(player, shop);
            } else if (slot == 26) {
                this.manager.removeShop(shop.getSignLocation());
                shop.getSignLocation().getBlock().setType(Material.AIR);
                player.closeInventory();
                player.sendMessage(PREFIX.append((Component)Component.text((String)"SleepyShop disbanded.", (TextColor)NamedTextColor.YELLOW)));
            }
        } else if (title.equals("Shop Price Settings")) {
            if (slot == 31) {
                this.guiProvider.openOwnerGui(player, shop);
            } else if (slot == 10) {
                this.adjustTakeAmount(shop, -10, player);
            } else if (slot == 11) {
                this.adjustTakeAmount(shop, -1, player);
            } else if (slot == 15) {
                this.adjustTakeAmount(shop, 1, player);
            } else if (slot == 16) {
                this.adjustTakeAmount(shop, 10, player);
            } else if (slot == 19) {
                this.adjustOutputAmount(shop, -10, player);
            } else if (slot == 20) {
                this.adjustOutputAmount(shop, -1, player);
            } else if (slot == 24) {
                this.adjustOutputAmount(shop, 1, player);
            } else if (slot == 25) {
                this.adjustOutputAmount(shop, 10, player);
            }
        } else if (title.equals("Shop Item Settings")) {
            ItemStack cursor;
            if (slot == 18) {
                this.guiProvider.openOwnerGui(player, shop);
            } else if (slot == 11) {
                ItemStack cursor2 = event.getCursor();
                if (cursor2 != null && cursor2.getType() != Material.AIR) {
                    ItemStack shopItem = cursor2.clone();
                    shopItem.setAmount(1);
                    shop.setSellItem(shopItem);
                    this.manager.saveShop(shop);
                    player.sendMessage(PREFIX.append((Component)Component.text((String)("Sell item set to " + shopItem.getType().name()), (TextColor)NamedTextColor.GREEN)));
                    this.guiProvider.openItemsGui(player, shop);
                }
            } else if (slot == 15 && (cursor = event.getCursor()) != null && cursor.getType() != Material.AIR) {
                ItemStack payItem = cursor.clone();
                payItem.setAmount(1);
                shop.setPaymentItem(payItem);
                this.manager.saveShop(shop);
                player.sendMessage(PREFIX.append((Component)Component.text((String)("Payment item set to " + payItem.getType().name()), (TextColor)NamedTextColor.GREEN)));
                this.guiProvider.openItemsGui(player, shop);
            }
        } else if (title.equals("Other Settings")) {
            if (slot == 18) {
                this.guiProvider.openOwnerGui(player, shop);
            } else if (slot == 13) {
                this.namingSession.put(player.getUniqueId(), shop);
                player.closeInventory();
                player.sendMessage(PREFIX.append((Component)Component.text((String)"Please enter the shop name in chat (type 'cancel' to stop or 'reset' for default):", (TextColor)NamedTextColor.YELLOW)));
            } else if (slot == 11) {
                shop.setShowDisplay(!shop.isShowDisplay());
                this.manager.saveShop(shop);
                this.guiProvider.openOtherGui(player, shop);
            } else if (slot == 15) {
                shop.setShowStockMessage(!shop.isShowStockMessage());
                this.manager.saveShop(shop);
                this.guiProvider.openOtherGui(player, shop);
            }
        }
    }

    private void adjustTakeAmount(Shop shop, int delta, Player player) {
        shop.setTakeAmount(Math.max(0, shop.getTakeAmount() + delta));
        this.manager.saveShop(shop);
        this.guiProvider.openPriceGui(player, shop);
    }

    private void adjustOutputAmount(Shop shop, int delta, Player player) {
        shop.setOutputAmount(Math.max(1, Math.min(64, shop.getOutputAmount() + delta)));
        this.manager.saveShop(shop);
        this.guiProvider.openPriceGui(player, shop);
    }

    private void handleBuyerClick(InventoryClickEvent event, Player player, Shop shop) {
        if (event.getRawSlot() == 8) {
            this.performTransaction(player, shop);
        }
    }

    private void performTransaction(Player buyer, Shop shop) {
        if (shop.getSellItem() == null) {
            return;
        }
        Block chestBlock = shop.getChestLocation().getBlock();
        BlockState blockState = chestBlock.getState();
        if (!(blockState instanceof Chest)) {
            buyer.sendMessage(PREFIX.append((Component)Component.text((String)"Error: Chest not found!", (TextColor)NamedTextColor.RED)));
            return;
        }
        Chest chest = (Chest)blockState;
        Inventory chestInv = chest.getInventory();
        if (!chestInv.containsAtLeast(shop.getSellItem(), shop.getOutputAmount())) {
            buyer.sendMessage(PREFIX.append((Component)Component.text((String)"Shop is out of stock!", (TextColor)NamedTextColor.RED)));
            return;
        }
        ItemStack payment = shop.getPaymentItem().clone();
        payment.setAmount(shop.getTakeAmount());
        if (shop.getTakeAmount() > 0 && !buyer.getInventory().containsAtLeast(payment, shop.getTakeAmount())) {
            buyer.sendMessage(PREFIX.append((Component)Component.text((String)("You don't have enough " + payment.getType().name() + "!"), (TextColor)NamedTextColor.RED)));
            return;
        }
        if (shop.getTakeAmount() > 0) {
            buyer.getInventory().removeItem(new ItemStack[]{payment});
            chestInv.addItem(new ItemStack[]{payment});
        }
        ItemStack toGive = shop.getSellItem().clone();
        toGive.setAmount(shop.getOutputAmount());
        chestInv.removeItem(new ItemStack[]{toGive});
        buyer.getInventory().addItem(new ItemStack[]{toGive}).values().forEach(item -> buyer.getWorld().dropItem(buyer.getLocation(), item));
        buyer.sendMessage(PREFIX.append((Component)Component.text((String)"Purchase successful!", (TextColor)NamedTextColor.GREEN)));
        buyer.closeInventory();
        this.manager.updateDisplay(shop);
    }

    @EventHandler
    public void onChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        Shop shop = this.namingSession.remove(player.getUniqueId());
        if (shop == null) {
            return;
        }
        event.setCancelled(true);
        String name = PlainTextComponentSerializer.plainText().serialize(event.message());
        if (name.equalsIgnoreCase("cancel")) {
            player.sendMessage(PREFIX.append((Component)Component.text((String)"Shop naming cancelled.", (TextColor)NamedTextColor.RED)));
            return;
        }
        if (name.equalsIgnoreCase("reset")) {
            shop.setShopName(null);
            this.manager.saveShop(shop);
            player.sendMessage(PREFIX.append((Component)Component.text((String)"Shop name reset to default.", (TextColor)NamedTextColor.GREEN)));
            return;
        }
        shop.setShopName(name);
        this.manager.saveShop(shop);
        player.sendMessage(PREFIX.append((Component)Component.text((String)("Shop name set to: " + name), (TextColor)NamedTextColor.GREEN)));
    }
}

