/*
 * Decompiled with CFR 0.152.
 */
package com.jotrorox.shop.gui;

import com.jotrorox.shop.gui.ShopInventoryHolder;
import com.jotrorox.shop.model.Shop;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ShopGuiProvider {
    public static final String OWNER_GUI_TITLE = "SleepyShop Configuration";
    public static final String PRICE_GUI_TITLE = "Shop Price Settings";
    public static final String ITEMS_GUI_TITLE = "Shop Item Settings";
    public static final String OTHER_GUI_TITLE = "Other Settings";
    public static final String BUYER_GUI_TITLE = "Purchase Item";
    private static final Component PREFIX = Component.text((String)"[SleepyShop] ", (TextColor)NamedTextColor.BLUE);

    public void openOwnerGui(Player player, Shop shop) {
        Inventory inv = this.createBaseGui(shop, 27, OWNER_GUI_TITLE);
        inv.setItem(11, this.createGuiItem(Material.GOLD_INGOT, "Price Settings", NamedTextColor.GOLD, "Set output and take amounts"));
        inv.setItem(13, this.createGuiItem(Material.CHEST, "Item Settings", NamedTextColor.AQUA, "Set sell and payment items"));
        inv.setItem(15, this.createGuiItem(Material.REPEATER, OTHER_GUI_TITLE, NamedTextColor.GRAY, "Under construction..."));
        inv.setItem(26, this.createGuiItem(Material.BARRIER, "Disband Shop", NamedTextColor.RED, new String[0]));
        player.openInventory(inv);
    }

    public void openPriceGui(Player player, Shop shop) {
        Inventory inv = this.createBaseGui(shop, 36, PRICE_GUI_TITLE);
        inv.setItem(10, this.createGuiItem(Material.RED_STAINED_GLASS_PANE, "-10 Price", NamedTextColor.RED, new String[0]));
        inv.setItem(11, this.createGuiItem(Material.PINK_STAINED_GLASS_PANE, "-1 Price", NamedTextColor.LIGHT_PURPLE, new String[0]));
        ItemStack priceStatus = this.createGuiItem(Material.GOLD_INGOT, "Current Price: " + shop.getTakeAmount(), NamedTextColor.GOLD, new String[0]);
        ItemMeta priceMeta = priceStatus.getItemMeta();
        priceMeta.lore(List.of(Component.text((String)"This is what buyers pay per purchase", (TextColor)NamedTextColor.GRAY)));
        priceStatus.setItemMeta(priceMeta);
        inv.setItem(13, priceStatus);
        inv.setItem(15, this.createGuiItem(Material.LIME_STAINED_GLASS_PANE, "+1 Price", NamedTextColor.GREEN, new String[0]));
        inv.setItem(16, this.createGuiItem(Material.GREEN_STAINED_GLASS_PANE, "+10 Price", NamedTextColor.DARK_GREEN, new String[0]));
        inv.setItem(19, this.createGuiItem(Material.RED_STAINED_GLASS_PANE, "-10 Amount", NamedTextColor.RED, new String[0]));
        inv.setItem(20, this.createGuiItem(Material.PINK_STAINED_GLASS_PANE, "-1 Amount", NamedTextColor.LIGHT_PURPLE, new String[0]));
        ItemStack amountStatus = this.createGuiItem(Material.CHEST, "Current Amount: " + shop.getOutputAmount(), NamedTextColor.AQUA, new String[0]);
        ItemMeta amountMeta = amountStatus.getItemMeta();
        amountMeta.lore(List.of(Component.text((String)"This is what buyers receive per purchase", (TextColor)NamedTextColor.GRAY)));
        amountStatus.setItemMeta(amountMeta);
        inv.setItem(22, amountStatus);
        inv.setItem(24, this.createGuiItem(Material.LIME_STAINED_GLASS_PANE, "+1 Amount", NamedTextColor.GREEN, new String[0]));
        inv.setItem(25, this.createGuiItem(Material.GREEN_STAINED_GLASS_PANE, "+10 Amount", NamedTextColor.DARK_GREEN, new String[0]));
        inv.setItem(31, this.createBackItem());
        player.openInventory(inv);
    }

    public void openItemsGui(Player player, Shop shop) {
        Inventory inv = this.createBaseGui(shop, 27, ITEMS_GUI_TITLE);
        ItemStack sellItemSlot = shop.getSellItem() != null ? shop.getSellItem().clone() : new ItemStack(Material.BARRIER);
        ItemMeta sellMeta = sellItemSlot.getItemMeta();
        sellMeta.displayName(Component.text((String)"Item to Sell", (TextColor)NamedTextColor.AQUA).decoration(TextDecoration.ITALIC, false));
        ArrayList<TextComponent> sellLore = new ArrayList<TextComponent>();
        if (shop.getSellItem() == null) {
            sellLore.add(Component.text((String)"No item set!", (TextColor)NamedTextColor.RED));
        } else {
            sellLore.add(Component.text((String)("Currently: " + shop.getSellItem().getType().name()), (TextColor)NamedTextColor.GRAY));
        }
        sellLore.add(Component.text((String)"Click with an item in cursor to set", (TextColor)NamedTextColor.DARK_GRAY));
        sellMeta.lore(sellLore);
        sellItemSlot.setItemMeta(sellMeta);
        inv.setItem(11, sellItemSlot);
        ItemStack payItemSlot = shop.getPaymentItem() != null ? shop.getPaymentItem().clone() : new ItemStack(Material.BARRIER);
        ItemMeta payMeta = payItemSlot.getItemMeta();
        payMeta.displayName(Component.text((String)"Item to Accept as Payment", (TextColor)NamedTextColor.GOLD).decoration(TextDecoration.ITALIC, false));
        ArrayList<TextComponent> payLore = new ArrayList<TextComponent>();
        if (shop.getPaymentItem() == null) {
            payLore.add(Component.text((String)"No item set!", (TextColor)NamedTextColor.RED));
        } else {
            payLore.add(Component.text((String)("Currently: " + shop.getPaymentItem().getType().name()), (TextColor)NamedTextColor.GRAY));
        }
        payLore.add(Component.text((String)"Click with an item in cursor to set", (TextColor)NamedTextColor.DARK_GRAY));
        payMeta.lore(payLore);
        payItemSlot.setItemMeta(payMeta);
        inv.setItem(15, payItemSlot);
        inv.setItem(18, this.createBackItem());
        player.openInventory(inv);
    }

    public void openOtherGui(Player player, Shop shop) {
        Inventory inv = this.createBaseGui(shop, 27, OTHER_GUI_TITLE);
        String currentName = shop.getShopName() != null ? shop.getShopName() : "None (Default)";
        inv.setItem(13, this.createGuiItem(Material.NAME_TAG, "Set Shop Name", NamedTextColor.GOLD, "Current: " + currentName, "Click to change name in chat"));
        Material holoMaterial = shop.isShowDisplay() ? Material.LIME_DYE : Material.GRAY_DYE;
        String holoStatus = shop.isShowDisplay() ? "Enabled" : "Disabled";
        inv.setItem(11, this.createGuiItem(holoMaterial, "Floating Text", NamedTextColor.YELLOW, "Status: " + holoStatus, "Click to toggle shop display"));
        Material stockMaterial = shop.isShowStockMessage() ? Material.PAPER : Material.BARRIER;
        String stockStatus = shop.isShowStockMessage() ? "Enabled" : "Disabled";
        inv.setItem(15, this.createGuiItem(stockMaterial, "Out of Stock Warning", NamedTextColor.YELLOW, "Status: " + stockStatus, "Click to toggle 'OUT OF STOCK' message"));
        inv.setItem(18, this.createBackItem());
        player.openInventory(inv);
    }

    public void openBuyerGui(Player player, Shop shop) {
        Inventory inv = this.createBaseGui(shop, 9, BUYER_GUI_TITLE);
        if (shop.getSellItem() == null) {
            player.sendMessage(PREFIX.append((Component)Component.text((String)"This shop is not configured yet!", (TextColor)NamedTextColor.RED)));
            player.closeInventory();
            return;
        }
        ItemStack displayItem = shop.getSellItem().clone();
        displayItem.setAmount(shop.getOutputAmount());
        ItemMeta meta = displayItem.getItemMeta();
        List lore = meta.hasLore() ? meta.lore() : new ArrayList();
        lore.add(Component.text((String)""));
        lore.add(Component.text((String)"Price: ", (TextColor)NamedTextColor.GRAY).append((Component)Component.text((String)(shop.getTakeAmount() + " x " + shop.getPaymentItem().getType().name()), (TextColor)NamedTextColor.GOLD)));
        meta.lore(lore);
        displayItem.setItemMeta(meta);
        inv.setItem(4, displayItem);
        inv.setItem(8, this.createGuiItem(Material.EMERALD_BLOCK, "Confirm Purchase", NamedTextColor.GREEN, new String[0]));
        player.openInventory(inv);
    }

    private Inventory createBaseGui(Shop shop, int size, String title) {
        Inventory inv = Bukkit.createInventory((InventoryHolder)new ShopInventoryHolder(shop, title), (int)size, (Component)Component.text((String)title));
        ItemStack filler = this.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, " ");
        for (int i = 0; i < size; ++i) {
            inv.setItem(i, filler);
        }
        return inv;
    }

    private ItemStack createBackItem() {
        return this.createGuiItem(Material.ARROW, "Back", NamedTextColor.RED, new String[0]);
    }

    private ItemStack createGuiItem(Material material, String name) {
        return this.createGuiItem(material, name, NamedTextColor.WHITE, new String[0]);
    }

    private ItemStack createGuiItem(Material material, String name, NamedTextColor color, String ... loreLines) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)name, (TextColor)color).decoration(TextDecoration.ITALIC, false));
        if (loreLines.length > 0) {
            ArrayList<Component> lore = new ArrayList<Component>();
            for (String line : loreLines) {
                lore.add(Component.text((String)line, (TextColor)NamedTextColor.GRAY).decoration(TextDecoration.ITALIC, false));
            }
            meta.lore(lore);
        }
        item.setItemMeta(meta);
        return item;
    }
}

