/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.velocityGuard.utils;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffectType;

public class MovementUtils {
    private static final Set<Material> PASSABLE_BLOCKS = new HashSet<Material>();
    private static final Set<Material> ICE_BLOCKS = new HashSet<Material>();

    public static double calculateHorizontalDistance(Location from, Location to) {
        double dx = to.getX() - from.getX();
        double dz = to.getZ() - from.getZ();
        return Math.sqrt(dx * dx + dz * dz);
    }

    public static int getPlayerPing(Player player) {
        try {
            return player.getPing();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean isNearGround(Player player) {
        Location loc = player.getLocation();
        for (double x = -0.3; x <= 0.3; x += 0.3) {
            for (double z = -0.3; z <= 0.3; z += 0.3) {
                Block block = loc.clone().add(x, -0.5, z).getBlock();
                if (PASSABLE_BLOCKS.contains(block.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isInLiquid(Player player) {
        Location loc = player.getLocation();
        if (player.isSwimming()) {
            return true;
        }
        Block block = loc.getBlock();
        Block blockBelow = loc.clone().subtract(0.0, 0.1, 0.0).getBlock();
        if (block.getType() == Material.WATER || block.getType() == Material.LAVA || blockBelow.getType() == Material.WATER || blockBelow.getType() == Material.LAVA) {
            return true;
        }
        Location eyeLoc = player.getEyeLocation();
        Block eyeBlock = eyeLoc.getBlock();
        if (eyeBlock.getType() == Material.WATER || eyeBlock.getType() == Material.LAVA) {
            return true;
        }
        Block deeperBelow = loc.clone().subtract(0.0, 0.5, 0.0).getBlock();
        if (deeperBelow.getType() == Material.WATER || deeperBelow.getType() == Material.LAVA) {
            return true;
        }
        for (double x = -0.3; x <= 0.3; x += 0.3) {
            for (double z = -0.3; z <= 0.3; z += 0.3) {
                Block surroundingBlock = loc.clone().add(x, -0.2, z).getBlock();
                if (surroundingBlock.getType() != Material.WATER && surroundingBlock.getType() != Material.LAVA) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isOnIce(Player player) {
        Location loc = player.getLocation();
        Block blockBelow = loc.clone().subtract(0.0, 0.2, 0.0).getBlock();
        return ICE_BLOCKS.contains(blockBelow.getType());
    }

    public static double getMaxHorizontalSpeed(Player player, double baseSpeed, Long elytraLandingTime, Long lastDamageTime, Long lastRiptideTime, long currentTime, double knockbackMultiplier, int knockbackDuration, double riptideMultiplier, int riptideDuration, boolean isDragonDamage, boolean isVehicle, double vehicleSpeedMultiplier, double vehicleIceSpeedMultiplier, double bufferMultiplier, int ping, boolean latencyCompensationEnabled, double lowPingCompensation, double mediumPingCompensation, double highPingCompensation, double veryHighPingCompensation, double extremePingCompensation, double veryLowPingCompensation, double ultraPingCompensation, double insanePingCompensation, double elytraGlidingMultiplier, int elytraLandingDuration) {
        long timeSinceRiptide;
        double adjustment;
        int level;
        double maxSpeed = baseSpeed;
        if (player.hasPotionEffect(PotionEffectType.SPEED)) {
            level = player.getPotionEffect(PotionEffectType.SPEED).getAmplifier() + 1;
            maxSpeed += (double)level * 0.2 * baseSpeed;
        }
        if (player.hasPotionEffect(PotionEffectType.SLOWNESS) && (maxSpeed -= (double)(level = player.getPotionEffect(PotionEffectType.SLOWNESS).getAmplifier() + 1) * 0.15 * baseSpeed) < 0.1) {
            maxSpeed = 0.1;
        }
        if (player.isSprinting()) {
            maxSpeed *= 1.3;
        }
        if (MovementUtils.isInLiquid(player)) {
            maxSpeed *= 0.95;
        }
        if (player.isGliding()) {
            maxSpeed *= elytraGlidingMultiplier;
        }
        if (elytraLandingTime != null && currentTime - elytraLandingTime < (long)elytraLandingDuration) {
            maxSpeed *= 3.5;
        }
        if (lastDamageTime != null) {
            long timeSinceHit = currentTime - lastDamageTime;
            if (isDragonDamage) {
                if (timeSinceHit < 5000L) {
                    return 500.0;
                }
            } else if (timeSinceHit < (long)knockbackDuration) {
                adjustment = knockbackMultiplier * (1.0 - (double)timeSinceHit / (double)knockbackDuration);
                maxSpeed *= 1.0 + adjustment;
            }
        }
        if (lastRiptideTime != null && (timeSinceRiptide = currentTime - lastRiptideTime) < (long)riptideDuration) {
            adjustment = riptideMultiplier * (1.0 - (double)timeSinceRiptide / (double)riptideDuration);
            maxSpeed *= 1.0 + adjustment;
        }
        if (isVehicle) {
            maxSpeed = MovementUtils.isOnIce(player) ? (maxSpeed *= vehicleIceSpeedMultiplier) : (maxSpeed *= vehicleSpeedMultiplier);
        }
        if ((maxSpeed *= bufferMultiplier) > 20.0) {
            double dynamicBuffer = 1.0 + (maxSpeed - 20.0) / 40.0;
            maxSpeed *= dynamicBuffer;
        }
        if (latencyCompensationEnabled) {
            double latencyCompensationFactor = 1.0;
            latencyCompensationFactor = ping <= 20 ? 1.0 : (ping <= 50 ? veryLowPingCompensation : (ping <= 100 ? lowPingCompensation : (ping <= 200 ? mediumPingCompensation : (ping <= 300 ? highPingCompensation : (ping <= 500 ? veryHighPingCompensation : (ping <= 750 ? extremePingCompensation : (ping <= 1000 ? ultraPingCompensation : insanePingCompensation)))))));
            maxSpeed *= latencyCompensationFactor;
        }
        return maxSpeed;
    }

    public static boolean isRidingGhast(Player player) {
        if (player.isInsideVehicle() && player.getVehicle() != null) {
            return player.getVehicle().getType().toString().equals("HAPPY_GHAST");
        }
        return false;
    }

    public static boolean checkFlying(Player player, Location from, Location to, Map<UUID, Integer> airTicksMap, boolean debugEnabled, Logger logger) {
        UUID playerId = player.getUniqueId();
        boolean isNearGround = MovementUtils.isNearGround(player);
        boolean inWater = MovementUtils.isInLiquid(player);
        if (player.hasPotionEffect(PotionEffectType.LEVITATION)) {
            if (debugEnabled && airTicksMap.getOrDefault(playerId, 0) > 25) {
                logger.info(player.getName() + " has levitation effect - ignoring flight checks");
            }
            return false;
        }
        if (isNearGround || inWater) {
            airTicksMap.put(playerId, 0);
            return false;
        }
        int previousAirTicks = airTicksMap.getOrDefault(playerId, 0);
        int currentAirTicks = previousAirTicks + 1;
        airTicksMap.put(playerId, currentAirTicks);
        if (currentAirTicks > 25) {
            if (Math.abs(to.getY() - from.getY()) < 0.05 && !player.isGliding() && !player.isFlying()) {
                if (debugEnabled) {
                    logger.info(player.getName() + " potential hover cheat: air ticks=" + currentAirTicks);
                }
                return currentAirTicks > 40;
            }
            if (to.getY() > from.getY() && !player.isGliding() && !player.isFlying() && currentAirTicks > 30) {
                if (debugEnabled) {
                    logger.info(player.getName() + " ascending in air after " + currentAirTicks + " ticks");
                }
                return currentAirTicks > 40;
            }
        }
        return false;
    }

    static {
        PASSABLE_BLOCKS.add(Material.AIR);
        PASSABLE_BLOCKS.add(Material.CAVE_AIR);
        PASSABLE_BLOCKS.add(Material.VOID_AIR);
        PASSABLE_BLOCKS.add(Material.WATER);
        PASSABLE_BLOCKS.add(Material.LAVA);
        ICE_BLOCKS.add(Material.ICE);
        ICE_BLOCKS.add(Material.PACKED_ICE);
        ICE_BLOCKS.add(Material.BLUE_ICE);
        ICE_BLOCKS.add(Material.FROSTED_ICE);
    }
}

