/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.velocityGuard.listeners;

import com.jellypudding.velocityGuard.VelocityGuard;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.bukkit.Location;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PacketListener
implements Listener {
    private final VelocityGuard plugin;
    private final Map<UUID, Channel> playerChannels = new ConcurrentHashMap<UUID, Channel>();
    private static final String HANDLER_NAME = "velocity_guard_handler";
    private final AtomicInteger successfulPackets = new AtomicInteger(0);
    private final AtomicInteger failedPackets = new AtomicInteger(0);
    private final AtomicInteger vehiclePackets = new AtomicInteger(0);
    private final ExecutorService asyncExecutor;

    public PacketListener(VelocityGuard plugin) {
        this.plugin = plugin;
        this.asyncExecutor = Executors.newFixedThreadPool(2, r -> {
            Thread thread = new Thread(r, "VelocityGuard-Worker");
            thread.setDaemon(true);
            return thread;
        });
        plugin.getLogger().info("Initialising packet listener");
    }

    public void inject() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        final Player[] onlinePlayers = this.plugin.getServer().getOnlinePlayers().toArray(new Player[0]);
        new BukkitRunnable(){
            int index = 0;
            final int BATCH_SIZE = 10;

            public void run() {
                int processed = 0;
                while (this.index < onlinePlayers.length && processed < 10) {
                    Player player;
                    if (!PacketListener.this.injectPlayer(player = onlinePlayers[this.index++])) continue;
                    ++processed;
                }
                if (this.index >= onlinePlayers.length) {
                    PacketListener.this.plugin.getLogger().info("Packet listeners registered for " + this.index + " players");
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 1L, 1L);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        final Player player = event.getPlayer();
        this.asyncExecutor.execute(() -> {
            this.injectPlayer(player);
            new BukkitRunnable(){

                public void run() {
                    PacketListener.this.plugin.getMovementChecker().registerPlayer(player);
                }
            }.runTask((Plugin)this.plugin);
            if (this.plugin.isDebugEnabled()) {
                this.plugin.getLogger().info("VelocityGuard now tracking " + player.getName());
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        final UUID playerId = player.getUniqueId();
        this.asyncExecutor.execute(() -> {
            this.uninjectPlayer(player);
            new BukkitRunnable(){

                public void run() {
                    PacketListener.this.plugin.getMovementChecker().unregisterPlayer(playerId);
                }
            }.runTask((Plugin)this.plugin);
        });
    }

    public boolean injectPlayer(final Player player) {
        try {
            if (!(player instanceof CraftPlayer)) {
                this.plugin.getLogger().warning("Player " + player.getName() + " is not a CraftPlayer, cannot inject");
                return false;
            }
            CraftPlayer craftPlayer = (CraftPlayer)player;
            Channel channel = this.getChannel(craftPlayer);
            if (channel == null) {
                this.plugin.getLogger().warning("Could not get channel for player " + player.getName());
                return false;
            }
            this.playerChannels.put(player.getUniqueId(), channel);
            if (channel.pipeline().get(HANDLER_NAME) != null) {
                return true;
            }
            channel.pipeline().addBefore("packet_handler", HANDLER_NAME, (ChannelHandler)new ChannelDuplexHandler(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    block11: {
                        try {
                            if (msg instanceof ServerboundMovePlayerPacket) {
                                ServerboundMovePlayerPacket movePacket = (ServerboundMovePlayerPacket)msg;
                                if (movePacket.hasPos) {
                                    Location to;
                                    double x = movePacket.x;
                                    double y = movePacket.y;
                                    double z = movePacket.z;
                                    Location from = player.getLocation();
                                    if (from.distanceSquared(to = new Location(player.getWorld(), x, y, z)) > 0.001) {
                                        PacketListener.this.successfulPackets.incrementAndGet();
                                        boolean allowed = PacketListener.this.plugin.getMovementChecker().processMovement(player, from, to, false);
                                        if (!allowed) {
                                            return;
                                        }
                                    }
                                }
                            } else if (msg instanceof ServerboundMoveVehiclePacket) {
                                ServerboundMoveVehiclePacket vehiclePacket = (ServerboundMoveVehiclePacket)msg;
                                Entity vehicle = player.getVehicle();
                                if (vehicle != null) {
                                    PacketListener.this.vehiclePackets.incrementAndGet();
                                    double packetX = vehiclePacket.position().x;
                                    double packetY = vehiclePacket.position().y;
                                    double packetZ = vehiclePacket.position().z;
                                    Location vehicleLocation = vehicle.getLocation();
                                    double dx = packetX - vehicleLocation.getX();
                                    double dy = packetY - vehicleLocation.getY();
                                    double dz = packetZ - vehicleLocation.getZ();
                                    if (dx * dx + dy * dy + dz * dz > 0.001) {
                                        Location playerFrom = player.getLocation();
                                        Location playerTo = playerFrom.clone().add(dx, dy, dz);
                                        boolean allowed = PacketListener.this.plugin.getMovementChecker().processMovement(player, playerFrom, playerTo, true);
                                        if (!allowed) {
                                            return;
                                        }
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            PacketListener.this.failedPackets.incrementAndGet();
                            if (!PacketListener.this.plugin.isDebugEnabled()) break block11;
                            PacketListener.this.asyncExecutor.execute(() -> PacketListener.this.plugin.getLogger().warning("Error processing packet: " + e.getMessage()));
                        }
                    }
                    super.channelRead(ctx, msg);
                }
            });
            if (this.plugin.isDebugEnabled()) {
                this.asyncExecutor.execute(() -> this.plugin.getLogger().info("Successfully injected packet handler for " + player.getName()));
            }
            return true;
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            this.asyncExecutor.execute(() -> {
                this.plugin.getLogger().severe("Error injecting player " + player.getName() + ": " + errorMsg);
                if (this.plugin.isDebugEnabled()) {
                    e.printStackTrace();
                }
            });
            return false;
        }
    }

    private Channel getChannel(CraftPlayer player) {
        try {
            ServerPlayer handle = player.getHandle();
            ServerGamePacketListenerImpl connection = handle.connection;
            Connection networkManager = connection.connection;
            return networkManager.channel;
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            this.asyncExecutor.execute(() -> this.plugin.getLogger().severe("Error getting channel for player " + player.getName() + ": " + errorMsg));
            return null;
        }
    }

    public void uninject() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.uninjectPlayer(player);
        }
        this.asyncExecutor.shutdown();
        this.plugin.getLogger().info("All packet listeners have been removed");
    }

    public void uninjectPlayer(Player player) {
        if (player == null) {
            return;
        }
        UUID playerId = player.getUniqueId();
        Channel channel = this.playerChannels.remove(playerId);
        if (channel != null && channel.pipeline().get(HANDLER_NAME) != null) {
            channel.pipeline().remove(HANDLER_NAME);
            if (this.plugin.isDebugEnabled()) {
                this.asyncExecutor.execute(() -> this.plugin.getLogger().info("Removed packet handler from " + player.getName()));
            }
        }
    }
}

