/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.velocityGuard;

import com.jellypudding.velocityGuard.Metrics;
import com.jellypudding.velocityGuard.commands.VelocityGuardCommand;
import com.jellypudding.velocityGuard.listeners.DamageListener;
import com.jellypudding.velocityGuard.listeners.PacketListener;
import com.jellypudding.velocityGuard.listeners.TeleportListener;
import com.jellypudding.velocityGuard.listeners.TridentListener;
import com.jellypudding.velocityGuard.managers.ConfigManager;
import com.jellypudding.velocityGuard.processors.MovementChecker;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class VelocityGuard
extends JavaPlugin {
    private ConfigManager configManager;
    private MovementChecker movementChecker;
    private PacketListener packetListener;
    private DamageListener damageListener;
    private TeleportListener teleportListener;
    private TridentListener tridentListener;

    public void onEnable() {
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.movementChecker = new MovementChecker(this);
        this.packetListener = new PacketListener(this);
        this.damageListener = new DamageListener(this);
        this.teleportListener = new TeleportListener(this);
        this.tridentListener = new TridentListener(this);
        this.packetListener.inject();
        this.getServer().getPluginManager().registerEvents((Listener)this.damageListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.teleportListener, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.tridentListener, (Plugin)this);
        VelocityGuardCommand command = new VelocityGuardCommand(this);
        this.getCommand("velocityguard").setExecutor((CommandExecutor)command);
        this.getCommand("velocityguard").setTabCompleter((TabCompleter)command);
        int pluginId = 27560;
        new Metrics((Plugin)this, pluginId);
        this.getLogger().info("VelocityGuard has been enabled.");
    }

    public void onDisable() {
        if (this.packetListener != null) {
            this.packetListener.uninject();
        }
        this.getLogger().info("VelocityGuard has been disabled.");
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MovementChecker getMovementChecker() {
        return this.movementChecker;
    }

    public boolean isDebugEnabled() {
        return this.configManager != null && this.configManager.isDebugModeEnabled();
    }

    public void reloadConfigManager() {
        this.reloadConfig();
        this.configManager = new ConfigManager(this);
        this.movementChecker = new MovementChecker(this);
    }
}

