/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.velocityGuard.processors;

import com.jellypudding.velocityGuard.VelocityGuard;
import com.jellypudding.velocityGuard.utils.MovementUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MovementChecker {
    private final VelocityGuard plugin;
    private final Map<UUID, Integer> airTicks = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Long> lastMoveTime = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Integer> speedViolationsCounter = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Long> lastDamageTime = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Boolean> dragonDamage = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, Long> lastRiptideTime = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Boolean> wasGliding = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, Long> elytraLandingTime = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Long> movementBlockedUntil = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Boolean> needsReset = new ConcurrentHashMap<UUID, Boolean>();
    private final Map<UUID, Long> lastBlockedTime = new ConcurrentHashMap<UUID, Long>();
    private final ReentrantLock operationLock = new ReentrantLock();

    public MovementChecker(VelocityGuard plugin) {
        this.plugin = plugin;
    }

    public boolean processMovement(Player player, Location from, Location to, boolean isVehicle) {
        boolean justUsedRiptide;
        if (player == null || from == null || to == null) {
            return true;
        }
        if (player.isDead()) {
            return true;
        }
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        Long blockedUntil = this.movementBlockedUntil.get(playerId);
        if (blockedUntil != null && currentTime < blockedUntil) {
            long remainingTime;
            if (this.plugin.isDebugEnabled() && (remainingTime = (blockedUntil - currentTime) / 1000L) % 1L == 0L) {
                this.plugin.getLogger().info("Blocked movement for " + player.getName() + " - remaining: " + remainingTime + "s");
            }
            return false;
        }
        if (blockedUntil != null && currentTime >= blockedUntil) {
            if (this.plugin.isDebugEnabled()) {
                this.plugin.getLogger().info("Player " + player.getName() + " is now unblocked - will reset on next movement");
            }
            this.movementBlockedUntil.remove(playerId);
            this.needsReset.put(playerId, true);
            return true;
        }
        Long lastBlocked = this.lastBlockedTime.get(playerId);
        if (lastBlocked != null) {
            long estimatedPacketTime = currentTime;
            int ping = player.getPing();
            if ((estimatedPacketTime -= (long)Math.max(ping, 50)) < lastBlocked) {
                return false;
            }
        }
        if (this.needsReset.remove(playerId) != null) {
            if (this.plugin.isDebugEnabled()) {
                this.plugin.getLogger().info("Resetting movement data for " + player.getName() + " after unblock");
            }
            this.airTicks.remove(playerId);
            this.lastMoveTime.remove(playerId);
            this.lastBlockedTime.remove(playerId);
            return true;
        }
        if (from.getX() == to.getX() && from.getY() == to.getY() && from.getZ() == to.getZ()) {
            return true;
        }
        if (player.getGameMode().toString().contains("CREATIVE") || player.getGameMode().toString().contains("SPECTATOR")) {
            this.airTicks.remove(playerId);
            return true;
        }
        long timeDelta = currentTime - this.lastMoveTime.getOrDefault(playerId, currentTime - 50L);
        this.lastMoveTime.put(playerId, currentTime);
        timeDelta = Math.max(25L, Math.min(timeDelta, 200L));
        double horizontalDistance = MovementUtils.calculateHorizontalDistance(from, to);
        double horizontalSpeed = horizontalDistance / (double)timeDelta * 1000.0;
        boolean isCurrentlyGliding = player.isGliding();
        boolean wasGlidingPreviously = this.wasGliding.getOrDefault(playerId, false);
        this.wasGliding.put(playerId, isCurrentlyGliding);
        if (!isCurrentlyGliding && wasGlidingPreviously) {
            this.elytraLandingTime.put(playerId, currentTime);
        }
        boolean isRecentDragonDamage = this.dragonDamage.getOrDefault(playerId, false);
        int ping = MovementUtils.getPlayerPing(player);
        double maxSpeed = MovementUtils.getMaxHorizontalSpeed(player, this.plugin.getConfigManager().getMaxHorizontalSpeed(), this.elytraLandingTime.get(playerId), this.lastDamageTime.get(playerId), this.lastRiptideTime.get(playerId), currentTime, this.plugin.getConfigManager().getKnockbackMultiplier(), this.plugin.getConfigManager().getKnockbackDuration(), this.plugin.getConfigManager().getRiptideMultiplier(), this.plugin.getConfigManager().getRiptideDuration(), isRecentDragonDamage, isVehicle, this.plugin.getConfigManager().getVehicleSpeedMultiplier(), this.plugin.getConfigManager().getVehicleIceSpeedMultiplier(), this.plugin.getConfigManager().getBufferMultiplier(), ping, this.plugin.getConfigManager().isLatencyCompensationEnabled(), this.plugin.getConfigManager().getLowPingCompensation(), this.plugin.getConfigManager().getMediumPingCompensation(), this.plugin.getConfigManager().getHighPingCompensation(), this.plugin.getConfigManager().getVeryHighPingCompensation(), this.plugin.getConfigManager().getExtremePingCompensation(), this.plugin.getConfigManager().getVeryLowPingCompensation(), this.plugin.getConfigManager().getUltraPingCompensation(), this.plugin.getConfigManager().getInsanePingCompensation(), this.plugin.getConfigManager().getElytraGlidingMultiplier(), this.plugin.getConfigManager().getElytraLandingDuration());
        boolean speedViolation = false;
        Long recentDamage = this.lastDamageTime.get(playerId);
        Long recentRiptide = this.lastRiptideTime.get(playerId);
        boolean justTookDamage = recentDamage != null && currentTime - recentDamage < 150L;
        boolean bl = justUsedRiptide = recentRiptide != null && currentTime - recentRiptide < 1500L;
        if (horizontalSpeed > maxSpeed) {
            if (!justTookDamage && !justUsedRiptide) {
                int burstTolerance = this.plugin.getConfigManager().getBurstToleranceForPing(ping);
                int violations = this.speedViolationsCounter.getOrDefault(playerId, 0) + 1;
                this.speedViolationsCounter.put(playerId, violations);
                if (violations > burstTolerance) {
                    speedViolation = true;
                    if (this.plugin.isDebugEnabled()) {
                        String vehicleInfo = isVehicle ? " (in vehicle)" : "";
                        this.plugin.getLogger().info(player.getName() + " speed violation" + vehicleInfo + ": " + String.format("%.2f", horizontalSpeed) + " blocks/s (max allowed: " + String.format("%.2f", maxSpeed) + "), ping: " + ping + "ms, violations: " + violations + "/" + burstTolerance);
                    }
                } else if (this.plugin.isDebugEnabled()) {
                    this.plugin.getLogger().info(player.getName() + " exceeded speed but within burst tolerance (" + violations + "/" + burstTolerance + "): " + String.format("%.2f", horizontalSpeed) + " blocks/s (max allowed: " + String.format("%.2f", maxSpeed) + ")");
                }
            } else if (this.plugin.isDebugEnabled()) {
                String reason = justTookDamage ? "recently damaged" : "recently used riptide";
                this.plugin.getLogger().info(player.getName() + " exceeded speed limit but was " + reason + " - ignoring.");
                this.speedViolationsCounter.put(playerId, 0);
            }
        } else {
            this.speedViolationsCounter.put(playerId, 0);
        }
        boolean flyingViolation = false;
        if (!speedViolation && this.plugin.getConfigManager().isFlightCheckEnabled()) {
            boolean isRidingGhast = MovementUtils.isRidingGhast(player);
            if (!justUsedRiptide && !isRidingGhast) {
                flyingViolation = MovementUtils.checkFlying(player, from, to, this.airTicks, this.plugin.isDebugEnabled(), this.plugin.getLogger());
            } else if (this.plugin.isDebugEnabled() && this.airTicks.getOrDefault(playerId, 0) > 30) {
                Object reason;
                Object object = reason = justUsedRiptide ? "recent riptide use" : "riding ghast";
                if (isRidingGhast && player.getVehicle() != null) {
                    String entityType = player.getVehicle().getType().toString();
                    reason = "riding " + entityType.toLowerCase();
                }
                this.plugin.getLogger().info(player.getName() + " exempt from flight checks due to " + (String)reason);
            }
        }
        if (speedViolation || flyingViolation && this.airTicks.getOrDefault(playerId, 0) > 40) {
            String message = speedViolation ? "Excessive speed detected" : "Illegal flight detected";
            this.blockPlayerMovement(player, message);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockPlayerMovement(final Player player, final String reason) {
        UUID playerId = player.getUniqueId();
        final int blockDuration = this.plugin.getConfigManager().getCancelDuration();
        long currentTime = System.currentTimeMillis();
        long blockedUntil = currentTime + (long)blockDuration * 1000L;
        this.operationLock.lock();
        try {
            this.movementBlockedUntil.put(playerId, blockedUntil);
            this.lastBlockedTime.put(playerId, currentTime);
        }
        finally {
            this.operationLock.unlock();
        }
        new BukkitRunnable(){

            public void run() {
                try {
                    if (player.isOnline()) {
                        String unit = blockDuration == 1 ? "second" : "seconds";
                        player.sendMessage("\u00a7c[VelocityGuard] \u00a7f" + reason + ". Movement blocked for " + blockDuration + " " + unit + ".");
                        if (MovementChecker.this.plugin.isDebugEnabled()) {
                            MovementChecker.this.plugin.getLogger().info("Blocked all movement for " + player.getName() + " for " + blockDuration + " " + unit + ". Reason: " + reason);
                        }
                    }
                }
                catch (Exception e) {
                    MovementChecker.this.plugin.getLogger().warning("Error notifying player " + player.getName() + ": " + e.getMessage());
                }
            }
        }.runTask((Plugin)this.plugin);
    }

    public void recordPlayerDamage(Player player, boolean isDragonDamage) {
        if (player == null) {
            return;
        }
        UUID playerId = player.getUniqueId();
        this.lastDamageTime.put(playerId, System.currentTimeMillis());
        this.dragonDamage.put(playerId, isDragonDamage);
        if (this.plugin.isDebugEnabled()) {
            this.plugin.getLogger().info(player.getName() + " took damage" + (isDragonDamage ? " from dragon" : "") + " - adjusting speed threshold for knockback");
        }
    }

    public void recordRiptideUse(Player player) {
        if (player == null) {
            return;
        }
        UUID playerId = player.getUniqueId();
        this.lastRiptideTime.put(playerId, System.currentTimeMillis());
        if (this.plugin.isDebugEnabled()) {
            this.plugin.getLogger().info(player.getName() + " used trident with riptide enchantment - adjusting speed threshold");
        }
    }

    public void registerPlayer(Player player) {
        if (player == null) {
            return;
        }
        UUID playerId = player.getUniqueId();
        this.airTicks.put(playerId, 0);
        this.wasGliding.put(playerId, player.isGliding());
        this.lastDamageTime.remove(playerId);
        this.lastRiptideTime.remove(playerId);
        this.speedViolationsCounter.put(playerId, 0);
        this.movementBlockedUntil.remove(playerId);
    }

    public void unregisterPlayer(UUID playerId) {
        if (playerId == null) {
            return;
        }
        this.airTicks.remove(playerId);
        this.lastMoveTime.remove(playerId);
        this.wasGliding.remove(playerId);
        this.elytraLandingTime.remove(playerId);
        this.movementBlockedUntil.remove(playerId);
        this.needsReset.remove(playerId);
        this.lastDamageTime.remove(playerId);
        this.dragonDamage.remove(playerId);
        this.lastRiptideTime.remove(playerId);
        this.speedViolationsCounter.remove(playerId);
        this.lastBlockedTime.remove(playerId);
    }
}

