/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.velocityGuard.managers;

import com.jellypudding.velocityGuard.VelocityGuard;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final VelocityGuard plugin;
    private final FileConfiguration config;
    private final double maxHorizontalSpeed;
    private final int cancelDuration;
    private final double knockbackMultiplier;
    private final int knockbackDuration;
    private final double riptideMultiplier;
    private final int riptideDuration;
    private final double elytraGlidingMultiplier;
    private final int elytraLandingDuration;
    private final double vehicleSpeedMultiplier;
    private final double vehicleIceSpeedMultiplier;
    private final double bufferMultiplier;
    private final boolean debugMode;
    private final boolean flightCheckEnabled;
    private final boolean enableLatencyCompensation;
    private final double veryLowPingCompensation;
    private final double lowPingCompensation;
    private final double mediumPingCompensation;
    private final double highPingCompensation;
    private final double veryHighPingCompensation;
    private final double extremePingCompensation;
    private final double ultraPingCompensation;
    private final double insanePingCompensation;
    private final int defaultBurstTolerance;
    private final int veryLowPingBurstTolerance;
    private final int lowPingBurstTolerance;
    private final int mediumPingBurstTolerance;
    private final int highPingBurstTolerance;
    private final int veryHighPingBurstTolerance;
    private final int extremePingBurstTolerance;
    private final int ultraPingBurstTolerance;
    private final int insanePingBurstTolerance;
    private static final double DEFAULT_MAX_HORIZONTAL_SPEED = 10.0;
    private static final int DEFAULT_CANCEL_DURATION = 3;
    private static final double DEFAULT_KNOCKBACK_MULTIPLIER = 6.0;
    private static final int DEFAULT_KNOCKBACK_DURATION = 1000;
    private static final double DEFAULT_RIPTIDE_MULTIPLIER = 8.0;
    private static final int DEFAULT_RIPTIDE_DURATION = 3000;
    private static final double DEFAULT_ELYTRA_GLIDING_MULTIPLIER = 3.0;
    private static final int DEFAULT_ELYTRA_LANDING_DURATION = 1500;
    private static final double DEFAULT_VEHICLE_SPEED_MULTIPLIER = 1.9;
    private static final double DEFAULT_VEHICLE_ICE_SPEED_MULTIPLIER = 4.3;
    private static final double DEFAULT_BUFFER_MULTIPLIER = 1.1;
    private static final boolean DEFAULT_FLIGHT_CHECK_ENABLED = true;
    private static final boolean DEFAULT_ENABLE_LATENCY_COMPENSATION = true;
    private static final double DEFAULT_VERY_LOW_PING_COMPENSATION = 1.1;
    private static final double DEFAULT_LOW_PING_COMPENSATION = 2.1;
    private static final double DEFAULT_MEDIUM_PING_COMPENSATION = 2.9;
    private static final double DEFAULT_HIGH_PING_COMPENSATION = 3.6;
    private static final double DEFAULT_VERY_HIGH_PING_COMPENSATION = 4.6;
    private static final double DEFAULT_EXTREME_PING_COMPENSATION = 5.7;
    private static final double DEFAULT_ULTRA_PING_COMPENSATION = 6.6;
    private static final double DEFAULT_INSANE_PING_COMPENSATION = 7.5;
    private static final int DEFAULT_DEFAULT_BURST_TOLERANCE = 15;
    private static final int DEFAULT_VERY_LOW_PING_BURST_TOLERANCE = 15;
    private static final int DEFAULT_LOW_PING_BURST_TOLERANCE = 20;
    private static final int DEFAULT_MEDIUM_PING_BURST_TOLERANCE = 22;
    private static final int DEFAULT_HIGH_PING_BURST_TOLERANCE = 24;
    private static final int DEFAULT_VERY_HIGH_PING_BURST_TOLERANCE = 27;
    private static final int DEFAULT_EXTREME_PING_BURST_TOLERANCE = 30;
    private static final int DEFAULT_ULTRA_PING_BURST_TOLERANCE = 33;
    private static final int DEFAULT_INSANE_PING_BURST_TOLERANCE = 35;

    public ConfigManager(VelocityGuard plugin) {
        this.plugin = plugin;
        this.plugin.saveDefaultConfig();
        this.config = plugin.getConfig();
        this.maxHorizontalSpeed = Math.max(4.0, this.config.getDouble("checks.speed.max-horizontal-speed", 10.0));
        this.cancelDuration = Math.max(1, this.config.getInt("checks.speed.cancel-duration", 3));
        this.knockbackMultiplier = Math.max(0.5, this.config.getDouble("checks.speed.knockback.multiplier", 6.0));
        this.knockbackDuration = Math.max(200, this.config.getInt("checks.speed.knockback.duration", 1000));
        this.riptideMultiplier = Math.max(1.0, this.config.getDouble("checks.speed.riptide.multiplier", 8.0));
        this.riptideDuration = Math.max(500, this.config.getInt("checks.speed.riptide.duration", 3000));
        this.elytraGlidingMultiplier = Math.max(1.0, this.config.getDouble("checks.speed.elytra.gliding-multiplier", 3.0));
        this.elytraLandingDuration = Math.max(500, this.config.getInt("checks.speed.elytra.landing-duration", 1500));
        this.vehicleSpeedMultiplier = Math.max(1.0, this.config.getDouble("checks.speed.vehicle-speed-multiplier", 1.9));
        this.vehicleIceSpeedMultiplier = Math.max(1.0, this.config.getDouble("checks.speed.vehicle-ice-speed-multiplier", 4.3));
        this.bufferMultiplier = Math.max(1.0, this.config.getDouble("checks.speed.buffer-multiplier", 1.1));
        this.flightCheckEnabled = this.config.getBoolean("checks.flight.enabled", true);
        this.enableLatencyCompensation = this.config.getBoolean("checks.speed.latency-compensation.enabled", true);
        this.veryLowPingCompensation = Math.max(1.0, this.config.getDouble("checks.speed.latency-compensation.very-low-ping", 1.1));
        this.lowPingCompensation = Math.max(1.0, this.config.getDouble("checks.speed.latency-compensation.low-ping", 2.1));
        this.mediumPingCompensation = Math.max(1.0, this.config.getDouble("checks.speed.latency-compensation.medium-ping", 2.9));
        this.highPingCompensation = Math.max(1.0, this.config.getDouble("checks.speed.latency-compensation.high-ping", 3.6));
        this.veryHighPingCompensation = Math.max(1.0, this.config.getDouble("checks.speed.latency-compensation.very-high-ping", 4.6));
        this.extremePingCompensation = Math.max(1.0, this.config.getDouble("checks.speed.latency-compensation.extreme-ping", 5.7));
        this.ultraPingCompensation = Math.max(1.0, this.config.getDouble("checks.speed.latency-compensation.ultra-ping", 6.6));
        this.insanePingCompensation = Math.max(1.0, this.config.getDouble("checks.speed.latency-compensation.insane-ping", 7.5));
        this.defaultBurstTolerance = Math.max(1, this.config.getInt("checks.speed.burst-tolerance.default", 15));
        this.veryLowPingBurstTolerance = Math.max(1, this.config.getInt("checks.speed.burst-tolerance.very-low-ping", 15));
        this.lowPingBurstTolerance = Math.max(1, this.config.getInt("checks.speed.burst-tolerance.low-ping", 20));
        this.mediumPingBurstTolerance = Math.max(1, this.config.getInt("checks.speed.burst-tolerance.medium-ping", 22));
        this.highPingBurstTolerance = Math.max(1, this.config.getInt("checks.speed.burst-tolerance.high-ping", 24));
        this.veryHighPingBurstTolerance = Math.max(1, this.config.getInt("checks.speed.burst-tolerance.very-high-ping", 27));
        this.extremePingBurstTolerance = Math.max(1, this.config.getInt("checks.speed.burst-tolerance.extreme-ping", 30));
        this.ultraPingBurstTolerance = Math.max(1, this.config.getInt("checks.speed.burst-tolerance.ultra-ping", 33));
        this.insanePingBurstTolerance = Math.max(1, this.config.getInt("checks.speed.burst-tolerance.insane-ping", 35));
        this.debugMode = this.config.getBoolean("settings.debug-mode", false);
    }

    public double getMaxHorizontalSpeed() {
        return this.maxHorizontalSpeed;
    }

    public int getCancelDuration() {
        return this.cancelDuration;
    }

    public boolean isDebugModeEnabled() {
        return this.debugMode;
    }

    public double getKnockbackMultiplier() {
        return this.knockbackMultiplier;
    }

    public int getKnockbackDuration() {
        return this.knockbackDuration;
    }

    public double getRiptideMultiplier() {
        return this.riptideMultiplier;
    }

    public int getRiptideDuration() {
        return this.riptideDuration;
    }

    public double getElytraGlidingMultiplier() {
        return this.elytraGlidingMultiplier;
    }

    public int getElytraLandingDuration() {
        return this.elytraLandingDuration;
    }

    public double getVehicleSpeedMultiplier() {
        return this.vehicleSpeedMultiplier;
    }

    public double getVehicleIceSpeedMultiplier() {
        return this.vehicleIceSpeedMultiplier;
    }

    public double getBufferMultiplier() {
        return this.bufferMultiplier;
    }

    public boolean isLatencyCompensationEnabled() {
        return this.enableLatencyCompensation;
    }

    public boolean isFlightCheckEnabled() {
        return this.flightCheckEnabled;
    }

    public double getVeryLowPingCompensation() {
        return this.veryLowPingCompensation;
    }

    public double getLowPingCompensation() {
        return this.lowPingCompensation;
    }

    public double getMediumPingCompensation() {
        return this.mediumPingCompensation;
    }

    public double getHighPingCompensation() {
        return this.highPingCompensation;
    }

    public double getVeryHighPingCompensation() {
        return this.veryHighPingCompensation;
    }

    public double getExtremePingCompensation() {
        return this.extremePingCompensation;
    }

    public double getUltraPingCompensation() {
        return this.ultraPingCompensation;
    }

    public double getInsanePingCompensation() {
        return this.insanePingCompensation;
    }

    public int getBurstToleranceForPing(int ping) {
        if (ping <= 20) {
            return this.defaultBurstTolerance;
        }
        if (ping <= 50) {
            return this.veryLowPingBurstTolerance;
        }
        if (ping <= 100) {
            return this.lowPingBurstTolerance;
        }
        if (ping <= 200) {
            return this.mediumPingBurstTolerance;
        }
        if (ping <= 300) {
            return this.highPingBurstTolerance;
        }
        if (ping <= 500) {
            return this.veryHighPingBurstTolerance;
        }
        if (ping <= 750) {
            return this.extremePingBurstTolerance;
        }
        if (ping <= 1000) {
            return this.ultraPingBurstTolerance;
        }
        return this.insanePingBurstTolerance;
    }
}

