/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.velocityGuard.listeners;

import com.jellypudding.velocityGuard.VelocityGuard;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;

public class DamageListener
implements Listener {
    private final VelocityGuard plugin;

    public DamageListener(VelocityGuard plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getEntity();
        boolean isDragonDamage = event instanceof EntityDamageByEntityEvent && ((EntityDamageByEntityEvent)event).getDamager().getType() == EntityType.ENDER_DRAGON;
        this.plugin.getMovementChecker().recordPlayerDamage(player, isDragonDamage);
        if (this.plugin.isDebugEnabled()) {
            if (event instanceof EntityDamageByEntityEvent) {
                EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)event;
                this.plugin.getLogger().info(player.getName() + " was hit by " + entityEvent.getDamager().getName() + " for " + event.getDamage() + " damage" + (isDragonDamage ? " (dragon damage)" : ""));
            } else if (event.getCause() != EntityDamageEvent.DamageCause.CUSTOM) {
                this.plugin.getLogger().info(player.getName() + " took damage: " + String.valueOf(event.getCause()) + " for " + event.getDamage() + " damage" + (isDragonDamage ? " (dragon damage)" : ""));
            }
        }
    }
}

