/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.stopSpam;

import com.jellypudding.stopSpam.Metrics;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class StopSpam
extends JavaPlugin
implements Listener {
    private final Map<UUID, Long> lastMessageTime = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, Integer> violationCount = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Long> timeoutUntil = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, LinkedList<MessageEntry>> recentMessages = new ConcurrentHashMap<UUID, LinkedList<MessageEntry>>();
    private final Map<Integer, Integer> timeoutDurations = new HashMap<Integer, Integer>();
    private final Random random = new Random();
    private long messageCooldown;
    private List<String> warningMessages;
    private boolean similarityEnabled;
    private double similarityThreshold;
    private int recentMessagesToCheck;
    private int similarityTimeWindow;
    private int repetitionThreshold;
    private boolean rateLimitEnabled;
    private int rateLimitMaxMessages;
    private int rateLimitTimeWindow;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.scheduleCleanupTask();
        int pluginId = 27566;
        new Metrics((Plugin)this, pluginId);
        this.getLogger().info("StopSpam has been enabled.");
    }

    public void onDisable() {
        this.getLogger().info("StopSpam has been disabled.");
    }

    private void loadConfig() {
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.messageCooldown = config.getLong("message-cooldown", 280L);
        this.warningMessages = config.getStringList("warning-messages");
        if (this.warningMessages.isEmpty()) {
            this.warningMessages = Collections.singletonList("Please slow down your messages!");
        }
        this.rateLimitEnabled = config.getBoolean("rate-limit.enabled", true);
        this.rateLimitMaxMessages = config.getInt("rate-limit.max-messages", 9);
        this.rateLimitTimeWindow = config.getInt("rate-limit.time-window", 5);
        this.similarityEnabled = config.getBoolean("similarity.enabled", true);
        this.similarityThreshold = config.getDouble("similarity.threshold", 0.9);
        this.recentMessagesToCheck = config.getInt("similarity.recent-messages-to-check", 15);
        this.similarityTimeWindow = config.getInt("similarity.time-window", 80);
        this.repetitionThreshold = config.getInt("similarity.repetition-threshold", 4);
        this.timeoutDurations.clear();
        this.timeoutDurations.put(1, config.getInt("timeouts.first", 10));
        this.timeoutDurations.put(2, config.getInt("timeouts.second", 20));
        this.timeoutDurations.put(3, config.getInt("timeouts.third", 30));
        this.timeoutDurations.put(4, config.getInt("timeouts.fourth", 100));
        this.timeoutDurations.put(5, config.getInt("timeouts.fifth", 300));
        this.timeoutDurations.put(6, config.getInt("timeouts.sixth", 600));
        this.timeoutDurations.put(7, config.getInt("timeouts.seventh", 1200));
        this.timeoutDurations.put(8, config.getInt("timeouts.eighth", 1800));
    }

    private void scheduleCleanupTask() {
        long hourlyCleanupInterval = 288000L;
        this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> {
            long currentTime = System.currentTimeMillis();
            this.timeoutUntil.entrySet().removeIf(entry -> currentTime > (Long)entry.getValue());
            long fourHoursAgo = currentTime - 14400000L;
            this.lastMessageTime.entrySet().removeIf(entry -> (Long)entry.getValue() < fourHoursAgo);
            this.violationCount.entrySet().removeIf(entry -> !this.lastMessageTime.containsKey(entry.getKey()));
            this.recentMessages.entrySet().removeIf(entry -> !this.lastMessageTime.containsKey(entry.getKey()));
            this.getLogger().info("Cleaned up expired timeouts and old violation records");
        }, hourlyCleanupInterval, hourlyCleanupInterval);
        long messageCleanupInterval = 1200L;
        this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> {
            long currentTime = System.currentTimeMillis();
            long expiryTime = currentTime - (long)this.similarityTimeWindow * 1000L;
            for (LinkedList<MessageEntry> messages : this.recentMessages.values()) {
                messages.removeIf(entry -> entry.getTimestamp() < expiryTime);
            }
        }, messageCleanupInterval, messageCleanupInterval);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (command.getName().equalsIgnoreCase("stopspam")) {
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("stopspam.admin")) {
                    sender.sendMessage((Component)Component.text((String)"You don't have permission to use StopSpam.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.loadConfig();
                sender.sendMessage((Component)Component.text((String)"StopSpam configuration reloaded.", (TextColor)NamedTextColor.GREEN));
                return true;
            }
            return false;
        }
        return false;
    }

    private double calculateSimilarity(String str1, String str2) {
        if (str1.equals(str2)) {
            return 1.0;
        }
        int distance = this.levenshteinDistance(str1, str2);
        double maxLength = Math.max(str1.length(), str2.length());
        return 1.0 - (double)distance / maxLength;
    }

    private int levenshteinDistance(String str1, String str2) {
        int i;
        int[][] distance = new int[str1.length() + 1][str2.length() + 1];
        for (i = 0; i <= str1.length(); ++i) {
            distance[i][0] = i;
        }
        for (int j = 0; j <= str2.length(); ++j) {
            distance[0][j] = j;
        }
        for (i = 1; i <= str1.length(); ++i) {
            for (int j = 1; j <= str2.length(); ++j) {
                int cost = str1.charAt(i - 1) == str2.charAt(j - 1) ? 0 : 1;
                distance[i][j] = Math.min(Math.min(distance[i - 1][j] + 1, distance[i][j - 1] + 1), distance[i - 1][j - 1] + cost);
            }
        }
        return distance[str1.length()][str2.length()];
    }

    private void applyViolation(Player player, UUID playerId, long currentTime, String reason) {
        int violations = this.violationCount.getOrDefault(playerId, 0) + 1;
        this.violationCount.put(playerId, violations);
        int cappedViolations = Math.min(violations, 8);
        int timeoutDuration = this.timeoutDurations.get(cappedViolations);
        this.timeoutUntil.put(playerId, currentTime + (long)timeoutDuration * 1000L);
        String message = reason != null ? "You have been muted for " + timeoutDuration + " seconds due to " + reason + "." : "You have been muted for " + timeoutDuration + " seconds.";
        player.sendMessage((Component)Component.text((String)message, (TextColor)NamedTextColor.RED));
    }

    private boolean checkTimeout(Player player, UUID playerId, long currentTime) {
        if (this.timeoutUntil.containsKey(playerId)) {
            long timeoutEnd = this.timeoutUntil.get(playerId);
            if (currentTime < timeoutEnd) {
                long remainingSeconds = (timeoutEnd - currentTime) / 1000L;
                player.sendMessage((Component)Component.text((String)("You are muted for " + remainingSeconds + " more seconds."), (TextColor)NamedTextColor.RED));
                return true;
            }
            this.timeoutUntil.remove(playerId);
        }
        return false;
    }

    private String extractMessageFromCommand(String command) {
        String[] parts;
        String lowerCommand = command.toLowerCase();
        if (lowerCommand.startsWith("/me ")) {
            return command.substring(4);
        }
        if ((lowerCommand.startsWith("/msg ") || lowerCommand.startsWith("/tell ") || lowerCommand.startsWith("/w ")) && (parts = command.split(" ", 3)).length >= 3) {
            return parts[2];
        }
        return null;
    }

    private boolean checkSpamAndApplyViolation(Player player, UUID playerId, String messageContent, long currentTime, String source) {
        long timeSinceLastMessage;
        if (!this.recentMessages.containsKey(playerId)) {
            this.recentMessages.put(playerId, new LinkedList());
        }
        LinkedList<MessageEntry> playerMessages = this.recentMessages.get(playerId);
        long expiryTime = currentTime - (long)this.similarityTimeWindow * 1000L;
        playerMessages.removeIf(entry -> entry.getTimestamp() < expiryTime);
        if (this.rateLimitEnabled) {
            long rateLimitExpiryTime = currentTime - (long)this.rateLimitTimeWindow * 1000L;
            int messagesInWindow = 1;
            for (MessageEntry entry2 : playerMessages) {
                if (entry2.getTimestamp() <= rateLimitExpiryTime) continue;
                ++messagesInWindow;
            }
            if (messagesInWindow > this.rateLimitMaxMessages) {
                String randomWarning = this.warningMessages.get(this.random.nextInt(this.warningMessages.size()));
                player.sendMessage((Component)Component.text((String)randomWarning, (TextColor)NamedTextColor.RED));
                this.applyViolation(player, playerId, currentTime, "sending " + source + " too quickly");
                return true;
            }
        }
        if (this.similarityEnabled && !playerMessages.isEmpty()) {
            HashMap<String, Integer> similarityGroups = new HashMap<String, Integer>();
            similarityGroups.put(messageContent, 1);
            for (MessageEntry entry3 : playerMessages) {
                String content = entry3.getContent();
                boolean added = false;
                for (String groupKey : new ArrayList(similarityGroups.keySet())) {
                    if (!(this.calculateSimilarity(content, groupKey) >= this.similarityThreshold)) continue;
                    similarityGroups.put(groupKey, (Integer)similarityGroups.get(groupKey) + 1);
                    added = true;
                    break;
                }
                if (added) continue;
                similarityGroups.put(content, 1);
            }
            boolean isSpam = false;
            for (Integer count : similarityGroups.values()) {
                if (count < this.repetitionThreshold) continue;
                isSpam = true;
                break;
            }
            if (isSpam) {
                String randomWarning = this.warningMessages.get(this.random.nextInt(this.warningMessages.size()));
                player.sendMessage((Component)Component.text((String)randomWarning, (TextColor)NamedTextColor.RED));
                this.applyViolation(player, playerId, currentTime, "repetitive " + source);
                return true;
            }
        }
        if (this.lastMessageTime.containsKey(playerId) && (timeSinceLastMessage = currentTime - this.lastMessageTime.get(playerId)) < this.messageCooldown) {
            String randomWarning = this.warningMessages.get(this.random.nextInt(this.warningMessages.size()));
            player.sendMessage((Component)Component.text((String)randomWarning, (TextColor)NamedTextColor.RED));
            this.applyViolation(player, playerId, currentTime, null);
            return true;
        }
        this.lastMessageTime.put(playerId, currentTime);
        playerMessages.addFirst(new MessageEntry(messageContent, currentTime));
        while (playerMessages.size() > this.recentMessagesToCheck) {
            playerMessages.removeLast();
        }
        return false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        String messageContent = this.extractMessageFromCommand(event.getMessage());
        if (messageContent != null && !messageContent.trim().isEmpty()) {
            if (this.checkTimeout(player, playerId, currentTime)) {
                event.setCancelled(true);
                return;
            }
            if (this.checkSpamAndApplyViolation(player, playerId, messageContent, currentTime, "commands")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        String messageContent = "";
        Component component = event.message();
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            messageContent = textComponent.content();
        } else {
            messageContent = event.message().toString();
        }
        if (this.checkTimeout(player, playerId, currentTime)) {
            event.setCancelled(true);
            return;
        }
        if (this.checkSpamAndApplyViolation(player, playerId, messageContent, currentTime, "messages")) {
            event.setCancelled(true);
        }
    }

    private static class MessageEntry {
        private final String content;
        private final long timestamp;

        public MessageEntry(String content, long timestamp) {
            this.content = content;
            this.timestamp = timestamp;
        }

        public String getContent() {
            return this.content;
        }

        public long getTimestamp() {
            return this.timestamp;
        }
    }
}

