/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleTPA;

import com.jellypudding.simpleTPA.Metrics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class SimpleTPA
extends JavaPlugin {
    private final HashMap<String, Long> teleportRequests = new HashMap();
    private final HashMap<String, BukkitTask> expirationTasks = new HashMap();
    private final HashMap<UUID, Long> cooldowns = new HashMap();
    private long requestTimeoutTicks;
    private long requestCooldownMillis;
    private boolean allowCrossWorld;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        Objects.requireNonNull(this.getCommand("tpa")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("tpa")).setTabCompleter((TabCompleter)this);
        Objects.requireNonNull(this.getCommand("tpaccept")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("tpaccept")).setTabCompleter((TabCompleter)this);
        Objects.requireNonNull(this.getCommand("tpdeny")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("tpdeny")).setTabCompleter((TabCompleter)this);
        Objects.requireNonNull(this.getCommand("tpacancel")).setExecutor((CommandExecutor)this);
        Objects.requireNonNull(this.getCommand("tpacancel")).setTabCompleter((TabCompleter)this);
        int pluginId = 27552;
        new Metrics((Plugin)this, pluginId);
        this.getLogger().info("SimpleTPA has been enabled.");
    }

    private void loadConfigValues() {
        int timeoutSeconds = this.getConfig().getInt("request-timeout", 120);
        this.requestTimeoutTicks = (long)timeoutSeconds * 20L;
        int cooldownSeconds = this.getConfig().getInt("request-cooldown", 10);
        this.requestCooldownMillis = (long)cooldownSeconds * 1000L;
        this.allowCrossWorld = this.getConfig().getBoolean("allow-cross-world", false);
        this.getLogger().info("Config loaded: timeout=" + timeoutSeconds + "s, cooldown=" + cooldownSeconds + "s, cross-world=" + this.allowCrossWorld);
    }

    public void onDisable() {
        this.expirationTasks.values().forEach(BukkitTask::cancel);
        this.teleportRequests.clear();
        this.expirationTasks.clear();
        this.cooldowns.clear();
        this.getLogger().info("SimpleTPA has been disabled.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(Component.text((String)"Only players can use teleportation commands.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("tpa")) {
            return this.handleTpaCommand(player, args);
        }
        if (command.getName().equalsIgnoreCase("tpaccept")) {
            return this.handleTpacceptCommand(player, args);
        }
        if (command.getName().equalsIgnoreCase("tpdeny")) {
            return this.handleTpdenyCommand(player, args);
        }
        if (command.getName().equalsIgnoreCase("tpacancel")) {
            return this.handleTpacancelCommand(player, args);
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("tpa") && args.length == 1) {
            String partialName = args[0].toLowerCase();
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(partialName)).filter(name -> !name.equals(sender.getName())).collect(Collectors.toList());
        }
        if (command.getName().equalsIgnoreCase("tpaccept") && args.length == 1) {
            String partialName = args[0].toLowerCase();
            UUID playerUUID = player.getUniqueId();
            return this.getPendingRequesters(playerUUID).stream().map(uuid -> Bukkit.getPlayer((UUID)uuid)).filter(Objects::nonNull).map(Player::getName).filter(name -> name.toLowerCase().startsWith(partialName)).collect(Collectors.toList());
        }
        if (command.getName().equalsIgnoreCase("tpdeny") && args.length == 1) {
            String partialName = args[0].toLowerCase();
            UUID playerUUID = player.getUniqueId();
            return this.getPendingRequesters(playerUUID).stream().map(uuid -> Bukkit.getPlayer((UUID)uuid)).filter(Objects::nonNull).map(Player::getName).filter(name -> name.toLowerCase().startsWith(partialName)).collect(Collectors.toList());
        }
        if (command.getName().equalsIgnoreCase("tpacancel") && args.length == 1) {
            String partialName = args[0].toLowerCase();
            UUID playerUUID = player.getUniqueId();
            ArrayList<String> suggestions = new ArrayList<String>();
            if ("all".startsWith(partialName)) {
                suggestions.add("all");
            }
            this.teleportRequests.keySet().stream().filter(key -> key.startsWith(playerUUID.toString() + ":")).forEach(requestKey -> {
                String[] parts = requestKey.split(":");
                if (parts.length == 2) {
                    try {
                        String name;
                        UUID targetUUID = UUID.fromString(parts[1]);
                        Player target = Bukkit.getPlayer((UUID)targetUUID);
                        if (target != null && target.isOnline() && (name = target.getName()).toLowerCase().startsWith(partialName)) {
                            suggestions.add(name);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            });
            return suggestions;
        }
        return Collections.emptyList();
    }

    private boolean handleTpaCommand(Player player, String[] args) {
        Object timeoutDisplay;
        long cooldownExpires;
        if (args.length < 1) {
            player.sendMessage(Component.text((String)"Usage: /tpa <player>").color((TextColor)NamedTextColor.RED));
            return true;
        }
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        if (this.cooldowns.containsKey(playerUUID) && currentTime < (cooldownExpires = this.cooldowns.get(playerUUID).longValue())) {
            long remainingSeconds = (cooldownExpires - currentTime) / 1000L + 1L;
            player.sendMessage(Component.text((String)("Please wait " + remainingSeconds + " seconds before sending another request.")).color((TextColor)NamedTextColor.RED));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            player.sendMessage(Component.text((String)"Player not found or is offline.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (target.getUniqueId().equals(player.getUniqueId())) {
            player.sendMessage(Component.text((String)"You cannot teleport to yourself.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (!this.allowCrossWorld && !player.getWorld().equals((Object)target.getWorld())) {
            player.sendMessage(Component.text((String)"You cannot teleport to a player in a different dimension.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        String requestKey = String.valueOf(player.getUniqueId()) + ":" + String.valueOf(target.getUniqueId());
        if (this.teleportRequests.containsKey(requestKey)) {
            player.sendMessage(Component.text((String)"You already have a pending request to this player.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        this.teleportRequests.put(requestKey, currentTime);
        this.cooldowns.put(playerUUID, currentTime + this.requestCooldownMillis);
        BukkitTask task = Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            if (this.teleportRequests.containsKey(requestKey)) {
                this.teleportRequests.remove(requestKey);
                this.expirationTasks.remove(requestKey);
                Component expiredMessage = ((TextComponent)((TextComponent)Component.text((String)"Your teleport request to ").color((TextColor)NamedTextColor.RED)).append(target.displayName())).append(Component.text((String)" has expired.").color((TextColor)NamedTextColor.RED));
                player.sendMessage(expiredMessage);
                Component targetMessage = ((TextComponent)((TextComponent)Component.text((String)"Teleport request from ").color((TextColor)NamedTextColor.RED)).append(player.displayName())).append(Component.text((String)" has expired.").color((TextColor)NamedTextColor.RED));
                target.sendMessage(targetMessage);
            }
        }, this.requestTimeoutTicks);
        this.expirationTasks.put(requestKey, task);
        int timeoutSeconds = (int)(this.requestTimeoutTicks / 20L);
        int minutes = timeoutSeconds / 60;
        int seconds = timeoutSeconds % 60;
        Object object = minutes > 0 ? minutes + " minute" + (minutes > 1 ? "s" : "") : (timeoutDisplay = "");
        if (seconds > 0) {
            if (!((String)timeoutDisplay).isEmpty()) {
                timeoutDisplay = (String)timeoutDisplay + " and ";
            }
            timeoutDisplay = (String)timeoutDisplay + seconds + " second" + (seconds > 1 ? "s" : "");
        }
        Component sentMessage = ((TextComponent)((TextComponent)Component.empty().append(Component.text((String)"Teleport request sent to ").color((TextColor)NamedTextColor.GREEN))).append(target.displayName())).append(Component.text((String)".").color((TextColor)NamedTextColor.GREEN));
        player.sendMessage(sentMessage);
        player.sendMessage(Component.text((String)("This request will expire in " + (String)timeoutDisplay + ".")).color((TextColor)NamedTextColor.YELLOW));
        Component receivedMessage = player.displayName().append(Component.text((String)" has requested to teleport to you.").color((TextColor)NamedTextColor.GREEN));
        target.sendMessage(receivedMessage);
        Component acceptMessage = ((TextComponent)((TextComponent)Component.empty().append(Component.text((String)"Type /tpaccept ").color((TextColor)NamedTextColor.YELLOW))).append(player.displayName())).append(Component.text((String)(" to accept. This request will expire in " + (String)timeoutDisplay + ".")).color((TextColor)NamedTextColor.YELLOW));
        target.sendMessage(acceptMessage);
        return true;
    }

    private boolean handleTpacceptCommand(Player player, String[] args) {
        UUID targetUUID = player.getUniqueId();
        List<UUID> pendingRequesters = this.getPendingRequesters(targetUUID);
        if (pendingRequesters.isEmpty()) {
            player.sendMessage(Component.text((String)"You don't have any pending teleport requests.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(Component.text((String)"Usage: /tpaccept <player>").color((TextColor)NamedTextColor.RED));
            player.sendMessage(Component.text((String)"Pending requests from:").color((TextColor)NamedTextColor.YELLOW));
            for (UUID requesterUUID : pendingRequesters) {
                Player requester = Bukkit.getPlayer((UUID)requesterUUID);
                if (requester == null || !requester.isOnline()) continue;
                Component listItem = ((TextComponent)Component.text((String)" - ").color((TextColor)NamedTextColor.GOLD)).append(requester.displayName());
                player.sendMessage(listItem);
            }
            return true;
        }
        String requesterName = args[0];
        Player requester = Bukkit.getPlayer((String)requesterName);
        if (requester == null || !requester.isOnline()) {
            player.sendMessage(Component.text((String)"Player not found or is offline.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        UUID requesterUUID = requester.getUniqueId();
        String requestKey = String.valueOf(requesterUUID) + ":" + String.valueOf(targetUUID);
        if (!this.teleportRequests.containsKey(requestKey)) {
            Component noRequestMessage = ((TextComponent)((TextComponent)Component.text((String)"You don't have a pending request from ").color((TextColor)NamedTextColor.RED)).append(requester.displayName())).append(Component.text((String)".").color((TextColor)NamedTextColor.RED));
            player.sendMessage(noRequestMessage);
            return true;
        }
        if (!this.allowCrossWorld && !player.getWorld().equals((Object)requester.getWorld())) {
            player.sendMessage(Component.text((String)"You cannot accept a teleport request from a player in a different dimension.").color((TextColor)NamedTextColor.RED));
            this.teleportRequests.remove(requestKey);
            this.cancelExpirationTask(requestKey);
            return true;
        }
        if (requester.isDead()) {
            Component deadMessage = ((TextComponent)((TextComponent)Component.empty().append(Component.text((String)"Cannot teleport ").color((TextColor)NamedTextColor.RED))).append(requester.displayName())).append(Component.text((String)" - they are currently dead.").color((TextColor)NamedTextColor.RED));
            player.sendMessage(deadMessage);
            Component requesterMessage = ((TextComponent)Component.empty().append(player.displayName())).append(Component.text((String)" tried to accept your teleport request but you were dead. Request cancelled.").color((TextColor)NamedTextColor.RED));
            requester.sendMessage(requesterMessage);
            this.teleportRequests.remove(requestKey);
            this.cancelExpirationTask(requestKey);
            return true;
        }
        requester.teleport(player.getLocation());
        Component teleportMessage = ((TextComponent)((TextComponent)Component.text((String)"Teleported to ").color((TextColor)NamedTextColor.GREEN)).append(player.displayName())).append(Component.text((String)".").color((TextColor)NamedTextColor.GREEN));
        requester.sendMessage(teleportMessage);
        Component notificationMessage = requester.displayName().append(Component.text((String)" has been teleported to you.").color((TextColor)NamedTextColor.GREEN));
        player.sendMessage(notificationMessage);
        this.teleportRequests.remove(requestKey);
        this.cancelExpirationTask(requestKey);
        return true;
    }

    private boolean handleTpdenyCommand(Player player, String[] args) {
        UUID targetUUID = player.getUniqueId();
        List<UUID> pendingRequesters = this.getPendingRequesters(targetUUID);
        if (pendingRequesters.isEmpty()) {
            player.sendMessage(Component.text((String)"You don't have any pending teleport requests.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length < 1) {
            player.sendMessage(Component.text((String)"Usage: /tpdeny <player>").color((TextColor)NamedTextColor.RED));
            player.sendMessage(Component.text((String)"Pending requests from:").color((TextColor)NamedTextColor.YELLOW));
            for (UUID requesterUUID : pendingRequesters) {
                Player requester = Bukkit.getPlayer((UUID)requesterUUID);
                if (requester == null || !requester.isOnline()) continue;
                Component listItem = ((TextComponent)Component.text((String)" - ").color((TextColor)NamedTextColor.GOLD)).append(requester.displayName());
                player.sendMessage(listItem);
            }
            return true;
        }
        String requesterName = args[0];
        Player requester = Bukkit.getPlayer((String)requesterName);
        if (requester == null || !requester.isOnline()) {
            player.sendMessage(Component.text((String)"Player not found or is offline.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        UUID requesterUUID = requester.getUniqueId();
        String requestKey = String.valueOf(requesterUUID) + ":" + String.valueOf(targetUUID);
        if (!this.teleportRequests.containsKey(requestKey)) {
            Component noRequestMessage = ((TextComponent)((TextComponent)Component.text((String)"You don't have a pending request from ").color((TextColor)NamedTextColor.RED)).append(requester.displayName())).append(Component.text((String)".").color((TextColor)NamedTextColor.RED));
            player.sendMessage(noRequestMessage);
            return true;
        }
        Component deniedMessage = player.displayName().append(Component.text((String)" has denied your teleport request.").color((TextColor)NamedTextColor.RED));
        requester.sendMessage(deniedMessage);
        Component confirmMessage = ((TextComponent)((TextComponent)Component.empty().append(Component.text((String)"You have denied ").color((TextColor)NamedTextColor.YELLOW))).append(requester.displayName())).append(Component.text((String)"'s teleport request.").color((TextColor)NamedTextColor.YELLOW));
        player.sendMessage(confirmMessage);
        this.teleportRequests.remove(requestKey);
        this.cancelExpirationTask(requestKey);
        return true;
    }

    private boolean handleTpacancelCommand(Player player, String[] args) {
        UUID playerUUID = player.getUniqueId();
        List playerRequests = this.teleportRequests.keySet().stream().filter(key -> key.startsWith(playerUUID.toString() + ":")).collect(Collectors.toList());
        if (playerRequests.isEmpty()) {
            player.sendMessage(Component.text((String)"You don't have any pending teleport requests.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length < 1) {
            if (playerRequests.size() == 1) {
                String requestKey = (String)playerRequests.get(0);
                String[] parts = requestKey.split(":");
                Player target = Bukkit.getPlayer((UUID)UUID.fromString(parts[1]));
                player.sendMessage(Component.text((String)"You have cancelled your teleport request.").color((TextColor)NamedTextColor.YELLOW));
                if (target != null && target.isOnline()) {
                    Component cancelMessage = player.displayName().append(Component.text((String)" has cancelled their teleport request.").color((TextColor)NamedTextColor.YELLOW));
                    target.sendMessage(cancelMessage);
                }
                this.teleportRequests.remove(requestKey);
                this.cancelExpirationTask(requestKey);
                return true;
            }
            player.sendMessage(Component.text((String)"Usage: /tpacancel <player> or /tpacancel all").color((TextColor)NamedTextColor.RED));
            player.sendMessage(Component.text((String)"You can cancel the following pending requests:").color((TextColor)NamedTextColor.YELLOW));
            for (String requestKey : playerRequests) {
                String[] parts = requestKey.split(":");
                Player target = Bukkit.getPlayer((UUID)UUID.fromString(parts[1]));
                if (target == null || !target.isOnline()) continue;
                Component listItem = ((TextComponent)Component.text((String)" - ").color((TextColor)NamedTextColor.GOLD)).append(target.displayName());
                player.sendMessage(listItem);
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("all")) {
            for (String requestKey : playerRequests) {
                String[] parts = requestKey.split(":");
                Player target = Bukkit.getPlayer((UUID)UUID.fromString(parts[1]));
                if (target != null && target.isOnline()) {
                    Component cancelMessage = player.displayName().append(Component.text((String)" has cancelled their teleport request.").color((TextColor)NamedTextColor.YELLOW));
                    target.sendMessage(cancelMessage);
                }
                this.teleportRequests.remove(requestKey);
                this.cancelExpirationTask(requestKey);
            }
            player.sendMessage(Component.text((String)"You have cancelled all your teleport requests.").color((TextColor)NamedTextColor.YELLOW));
            return true;
        }
        String targetName = args[0];
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null || !target.isOnline()) {
            player.sendMessage(Component.text((String)"Player not found or is offline.").color((TextColor)NamedTextColor.RED));
            return true;
        }
        UUID targetUUID = target.getUniqueId();
        String requestKey = String.valueOf(playerUUID) + ":" + String.valueOf(targetUUID);
        if (!this.teleportRequests.containsKey(requestKey)) {
            Component noRequestMessage = ((TextComponent)((TextComponent)Component.text((String)"You don't have a pending request to ").color((TextColor)NamedTextColor.RED)).append(target.displayName())).append(Component.text((String)".").color((TextColor)NamedTextColor.RED));
            player.sendMessage(noRequestMessage);
            return true;
        }
        this.teleportRequests.remove(requestKey);
        this.cancelExpirationTask(requestKey);
        Component cancelledMessage = ((TextComponent)((TextComponent)Component.empty().append(Component.text((String)"You have cancelled your teleport request to ").color((TextColor)NamedTextColor.YELLOW))).append(target.displayName())).append(Component.text((String)".").color((TextColor)NamedTextColor.YELLOW));
        player.sendMessage(cancelledMessage);
        Component targetMessage = player.displayName().append(Component.text((String)" has cancelled their teleport request.").color((TextColor)NamedTextColor.YELLOW));
        target.sendMessage(targetMessage);
        return true;
    }

    private List<UUID> getPendingRequesters(UUID playerUUID) {
        ArrayList<UUID> requesters = new ArrayList<UUID>();
        for (String requestKey : this.teleportRequests.keySet()) {
            String[] parts = requestKey.split(":");
            if (parts.length != 2 || !parts[1].equals(playerUUID.toString())) continue;
            try {
                UUID requesterUUID = UUID.fromString(parts[0]);
                requesters.add(requesterUUID);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return requesters;
    }

    private void cancelExpirationTask(String requestKey) {
        BukkitTask task = this.expirationTasks.remove(requestKey);
        if (task != null) {
            task.cancel();
        }
    }
}

