/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleLifesteal.utils;

import com.jellypudding.simpleLifesteal.SimpleLifesteal;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class HeartItemUtil {
    private final NamespacedKey heartKey;

    public HeartItemUtil(SimpleLifesteal plugin) {
        this.heartKey = new NamespacedKey((Plugin)plugin, "lifesteal_heart");
    }

    public ItemStack createHeartItem(int heartCount) {
        ItemStack item = new ItemStack(Material.APPLE, heartCount);
        ItemMeta meta = item.getItemMeta();
        meta.displayName(Component.text((String)"Heart", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).decoration(TextDecoration.ITALIC, false));
        meta.lore(List.of((TextComponent)Component.text((String)"Consume to regain a heart.", (TextColor)NamedTextColor.GREEN).decoration(TextDecoration.ITALIC, false)));
        meta.getPersistentDataContainer().set(this.heartKey, PersistentDataType.BOOLEAN, (Object)true);
        item.setItemMeta(meta);
        return item;
    }

    public boolean isHeartItem(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        return meta.getPersistentDataContainer().has(this.heartKey, PersistentDataType.BOOLEAN);
    }

    public NamespacedKey getHeartKey() {
        return this.heartKey;
    }
}

