/*
 * Decompiled with CFR 0.152.
 */
package com.jellypudding.simpleLifesteal.managers;

import com.jellypudding.simpleLifesteal.SimpleLifesteal;
import com.jellypudding.simpleLifesteal.database.DatabaseManager;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlayerDataManager {
    private final SimpleLifesteal plugin;
    private final DatabaseManager databaseManager;
    private final ConcurrentHashMap<UUID, Integer> heartCache;
    private final int startingHearts;
    private final int maxHearts;
    private final int minHearts = 0;

    public PlayerDataManager(SimpleLifesteal plugin) {
        this.plugin = plugin;
        this.databaseManager = plugin.getDatabaseManager();
        this.heartCache = new ConcurrentHashMap();
        this.startingHearts = plugin.getStartingHearts();
        this.maxHearts = plugin.getMaxHearts();
    }

    public void loadPlayerData(Player player, Consumer<Integer> callback) {
        UUID uuid = player.getUniqueId();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            int hearts = this.databaseManager.getPlayerHearts(uuid);
            if (hearts == -1) {
                hearts = this.startingHearts;
                this.databaseManager.setPlayerHearts(uuid, hearts);
            }
            int finalHearts = hearts;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                this.heartCache.put(uuid, finalHearts);
                if (player != null && player.isOnline()) {
                    this.updatePlayerMaxHealth(player, finalHearts);
                }
                if (callback != null) {
                    callback.accept(finalHearts);
                }
            });
        });
    }

    public void savePlayerData(UUID uuid, boolean removeFromCache) {
        if (this.heartCache.containsKey(uuid)) {
            int hearts = this.heartCache.get(uuid);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                this.databaseManager.setPlayerHearts(uuid, hearts);
                if (removeFromCache) {
                    this.heartCache.remove(uuid);
                }
            });
        } else {
            this.plugin.getLogger().warning("Attempted to save data for UUID " + String.valueOf(uuid) + " which was not in cache.");
        }
    }

    public void saveAllPlayerData() {
        this.plugin.getLogger().info("Saving all player heart data synchronously...");
        for (UUID uuid : this.heartCache.keySet()) {
            if (this.heartCache.containsKey(uuid)) {
                int hearts = this.heartCache.get(uuid);
                this.databaseManager.setPlayerHearts(uuid, hearts);
                continue;
            }
            this.plugin.getLogger().warning("Attempted to save data for UUID " + String.valueOf(uuid) + " which was not in cache during shutdown.");
        }
        this.plugin.getLogger().info("Finished saving player heart data synchronously.");
    }

    public int getPlayerHearts(UUID uuid) {
        if (this.heartCache.containsKey(uuid)) {
            return this.heartCache.get(uuid);
        }
        int dbHearts = this.databaseManager.getPlayerHearts(uuid);
        return dbHearts == -1 ? this.startingHearts : dbHearts;
    }

    public int getPlayerMaxHearts(UUID uuid) {
        Integer individualMax = this.databaseManager.getPlayerMaxHearts(uuid);
        return individualMax != null ? individualMax : this.maxHearts;
    }

    public void setPlayerMaxHearts(UUID uuid, int newMaxHearts) {
        if (newMaxHearts < 1) {
            this.plugin.getLogger().warning("Attempted to set max hearts to " + newMaxHearts + " for UUID " + String.valueOf(uuid) + " (minimum is 1)");
            return;
        }
        this.databaseManager.setPlayerMaxHearts(uuid, newMaxHearts);
        int currentHearts = this.getPlayerHearts(uuid);
        if (currentHearts > newMaxHearts) {
            this.setPlayerHearts(uuid, newMaxHearts);
        }
        this.plugin.getLogger().info("Set max hearts to " + newMaxHearts + " for UUID " + String.valueOf(uuid));
    }

    public boolean increasePlayerMaxHearts(UUID uuid, int amount) {
        if (amount <= 0) {
            return false;
        }
        int currentMax = this.getPlayerMaxHearts(uuid);
        int newMax = currentMax + amount;
        this.setPlayerMaxHearts(uuid, newMax);
        this.plugin.getLogger().info("Increased max hearts by " + amount + " for UUID " + String.valueOf(uuid) + " (new max: " + newMax + ")");
        return true;
    }

    private void setHeartsInternal(UUID uuid, int hearts) {
        int playerMaxHearts = this.getPlayerMaxHearts(uuid);
        hearts = Math.max(0, Math.min(hearts, playerMaxHearts));
        this.heartCache.put(uuid, hearts);
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null && player.isOnline()) {
            this.updatePlayerMaxHealth(player, hearts);
        }
    }

    private void updatePlayerMaxHealth(Player player, int hearts) {
        double newMaxHealth = Math.max(1.0, (double)hearts * 2.0);
        try {
            player.getAttribute(Attribute.MAX_HEALTH).setBaseValue(newMaxHealth);
            if (player.getHealth() > newMaxHealth) {
                player.setHealth(newMaxHealth);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to update max health for " + player.getName() + ": " + e.getMessage());
        }
    }

    public void setPlayerHearts(UUID uuid, int hearts) {
        this.setHeartsInternal(uuid, hearts);
        this.savePlayerData(uuid, false);
    }

    public void addHearts(UUID uuid, int amount) {
        int currentHearts = this.getPlayerHearts(uuid);
        int newHearts = currentHearts + amount;
        this.setPlayerHearts(uuid, newHearts);
    }

    public void removeHearts(UUID uuid, int amount) {
        int currentHearts = this.getPlayerHearts(uuid);
        int newHearts = currentHearts - amount;
        this.setPlayerHearts(uuid, newHearts);
    }

    public boolean givePlayerHearts(UUID playerUuid, int amount) {
        int playerMaxHearts;
        if (amount <= 0) {
            return false;
        }
        int currentHearts = this.getPlayerHearts(playerUuid);
        if (currentHearts >= (playerMaxHearts = this.getPlayerMaxHearts(playerUuid))) {
            return false;
        }
        int newHearts = currentHearts + amount;
        if (newHearts > playerMaxHearts) {
            newHearts = playerMaxHearts;
        }
        this.setPlayerHearts(playerUuid, newHearts);
        this.plugin.getLogger().info("API: Added " + (newHearts - currentHearts) + " heart(s) to " + String.valueOf(playerUuid) + ". New total: " + newHearts);
        return true;
    }
}

